@extends('layouts.landing-page')
@section('content')
<div class="mx-5 my-5 lg:mx-36 lg:my-20">
    
    <section class="grid my-5 md:grid-cols-2">
        <div class="flex items-center justify-center ">
            <img src="{{asset('storage/productos/cafe_org_500.jpg')}}" alt="imagen prooducto">
        </div>
        <div class="flex flex-col ">
            <h3 class="text-3xl font-bold dark:text-white">CAFÉ ORGÁNICO DE ESPECIALIDAD</h3>
            <h5 class="text-xl font-medium dark:text-white">Heading 5</h5>
            <h4 class="text-2xl font-bold dark:text-white">Selecciona tamaño</h4>
            <div class="flex  gap-3 w-[40%]">
            <div class="p-1 border-2 border-principal hover:cursor-pointer hover:bg-principal hover:text-white" >
                    250 gr.    
                </div>
            <div class="p-1 border-2 border-principal hover:cursor-pointer hover:bg-principal hover:text-white">
                    500 gr.
                </div>
            </div>
            <div class="inline-flex items-end mt-5">
                <img src="{{asset('storage/productos/icono_envio.png')}}" alt="">
                <p class="ml-1 text-xs font-normal dark:text-white">*EL ENVÍO SE CALCULA AL MOMENTO DE PAGAR</p>
            </div>
        
                <div class="flex gap-4 ">
                    <div class="flex items-center gap-2">
                        <button type="button" class="text-lg font-bold border-2 rounded-full size-10 border-principal hover:bg-gray-200" onclick="decrementQuantity()">-</button>
                        <input type="number" id="quantity" name="quantity" value="1" min="1" class="w-12 font-bold text-center rounded" readonly>
                        <button type="button"class="text-lg font-bold border-2 rounded-full size-10 border-principal hover:bg-gray-200onclick="incrementQuantity()">+</button>
                    </div>
                
                    <button class="w-full px-4 py-2 mt-3 text-lg font-semibold text-white rounded-2xl bg-principal hover:bg-principalhover">
                        AÑADIR AL CARRITO
                    </button>
                </div>

                <div class="w-full mt-4 border-t-4 border-b-4">
                    <h5 class="text-xl font-normal text-principal">FICHA TÉCNICA</h5>
                    <div class="flex flex-col ">
                        <div class="flex items-center mr-6">
                            <img src="{{ asset('storage/productos/icono_lugar.png') }}" alt="Altura" class="w-3 h-4 mr-2 ">
                            <span class="text-base dark:text-white">Origen | Jaltenango, Chiapas</span>
                        </div>
                        <div class="flex items-center mr-6">
                            
                            <img src="{{ asset('storage/productos/icono_granos.png') }}" alt="Variedad" class="w-4 h-4 mr-2">
                            <span class="text-base dark:text-white">Tueste | Oscuro</span>
                        </div>
                        <div class="flex items-center">
                            <img src="{{ asset('storage/productos/icono_hojas.png') }}" alt="Proceso" class="w-4 h-4 mr-2">
                            <span class="text-base dark:text-white">Tipo | Arábico</span>
                        </div>
                        <div class="flex items-center">
                            <img src="{{ asset('storage/productos/icono_reglas.png') }}" alt="Proceso" class="w-3 h-4 mr-2">
                            <span class="text-base dark:text-white">Origen | 1,350 msnm.</span>
                        </div>
                    </div>
                </div>

                <h5 class="text-xl font-normal text-principal">DESCRIPCIÓN</h5>
                <p class="font-semibold">Usamos variedad de mejor calidad con un proceso que resalta el sabor, recomendado también para preparar un café muy fuerte tipo espresso. </p>
        
        </div>
    </section>
    <section>
    {{-- productos --}}
    <h4 class="mx-5 text-2xl font-bold uppercase dark:text-white">También te puede interesar</h4>
    <section class="grid grid-cols-1 gap-3 lg:gap-8 md:grid-cols-3 ">
        <a href="{{route('product')}}" class="flex flex-col items-center justify-center">
            <img class="h-[60%] lg:h-auto" src="{{asset('storage/productos/cafe_org_500.jpg')}}" alt="producto">
            <h4 class="text-2xl font-semibold text-center lg:text-start">CAFÉ ORGÁNICO DE ESPECIALIDAD 500 gr.</h4>
        </a>
        <div class="flex flex-col items-center justify-center">
            <img class="h-[60%] lg:h-auto" src="{{asset('storage/productos/cafe_org_amer_7,5.jpg')}}" alt="producto">
            <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ORGÁNICO AMERICANO 7.5 kg.</h4>
        </div>
        <a class="flex flex-col items-center justify-center">
            <img class="h-[60%] lg:h-auto" src="{{asset('storage/productos/cafe_esp_amer_7,5.jpg')}}" alt="producto">
            <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ESPECIAL ORGÁNICO 7.5 kg.</h4>
        </a>
        <a class="flex flex-col items-center justify-center">
            <img class="h-[60%] lg:h-auto" src="{{asset('storage/productos/cafe_org_500.jpg')}}" alt="producto">
            <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ORGÁNICO DE ESPECIALIDAD 500 gr.</h4>
        </a>
        <a class="flex flex-col items-center justify-center">
            <img class="h-[60%] lg:h-auto" src="{{asset('storage/productos/cafe_org_amer_7,5.jpg')}}" alt="producto">
            <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ORGÁNICO AMERICANO 7.5 kg.</h4>
        </a>
        <a class="flex flex-col items-center justify-center">
            <img class="h-[60%] lg:h-auto" src="{{asset('storage/productos/cafe_esp_amer_7,5.jpg')}}" alt="producto">
            <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ESPECIAL ORGÁNICO 7.5 kg.</h4>
        </a>
    </section>
    {{-- productos --}}
        
    </section>
</div> 
@endsection