<?php

namespace App\Console\Commands;

use App\Helpers\Utility;
use App\Mail\NotificationMail;
use App\Models\Purchase;
use Carbon\Carbon;
use Illuminate\Console\Command;

class CloseQuotes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'close-quotes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        //
        $today = strtotime(Carbon::today()); // fecha actual (00:00:00)
        $purchases = Purchase::where('status_id',24)->get();
        foreach ($purchases as $item) {
            // info($today);
            // info(strtotime($item->payment_date));
            if (strtotime($item->payment_date) < $today) {
                $item->update(['status_id' => 11]);
                $message = 'El pedido con ID: '.$item->id.' tiene un nuevo estatus, entra en la sección de <a href="'. route('compras.index') .'"><strong>Detalles de Compra</strong></a>. Su pedido no fue pagado en la fecha límite de pago: '.date('d-m-Y',strtotime($item->payment_date)).'.';
                Utility::sendEmail($item->user->email, new NotificationMail($item->user,$item->status->name,$message));
            }
        }
    }
}
