<?php

namespace App\Helpers;

use MercadoPago\Client\Payment\PaymentClient;
use MercadoPago\Client\Common\RequestOptions;
use MercadoPago\MercadoPagoConfig;
use MercadoPago\Client\Preference\PreferenceClient;

class MercadoPago
{
    public static function payment($token, $id)
    {
        try {
            $data = [
                'token' => request()['formData']['token'],
                'issuer_id' => request()['formData']['issuer_id'],
                'payment_method_id' => request()['formData']['payment_method_id'],
                'transaction_amount' => (float) request()['formData']['transaction_amount'],
                'installments' => request()['formData']['installments'],
                'payer' => [
                    'email' => request()['formData']['payer']['email'],
                    'first_name' => 'Francisco',
                    'last_name' => 'Reyes',
                ],
                'description' => 'Compra de Articulo en Tienda en Linea.',
                'external_reference' => $id . '-' . $token,
                'statement_descriptor' => 'TiendaRopaDamas',
                'binary_mode' => true,
            ];

            // info($data);

            MercadoPagoConfig::setAccessToken(config('app.access_token'));

            $client = new PaymentClient();
            $request_options = new RequestOptions();
            $request_options->setCustomHeaders(['X-Idempotency-Key: ' . $token]);

            // info($token);
            $payment = $client->create($data, $request_options);

            $payment = collect($payment);
            // info($payment);

            return ['response' => $payment, 'code' => 200];
        } catch (\Throwable $th) {
            info($th);
            return ['response' => $th->getMessage(), 'code' => 500];
        }
    }

    public static function preference($items, $purchase)
    {
        $external_reference = 'CDV-' . $purchase->id.'-'.time(); //CDV = CODIGO DE VENTA
        MercadoPagoConfig::setAccessToken(config('app.access_token'));
        // info($purchase);

        $client = new PreferenceClient();
        $request_options = new RequestOptions();
        $request_options->setCustomHeaders(['X-Idempotency-Key: ' . $purchase->token]);

        // info('X-Idempotency-Key: ' . $purchase->token);
        
        $preference = $client->create([
            'items' => $items,
            'payment_methods' => [
                // 'excluded_payment_methods' => [],
                'excluded_payment_types' => [
                    ['id' => 'bank_transfer'],
                    ['id' => 'ticket']
                ],
                'installments' => 3,
            ],
            'payer' => [
                'name' => $purchase->user->person->first_name,
                'surname' => $purchase->user->person->first_surname,
                'email' => $purchase->user->email,
            ],
            'shipments' => [
                'cost'  => (double) $purchase->shipping,
                'mode'  => 'not_specified',
            ],
            'back_urls' => [
                'success' => route('purchase-response',['id'=>$purchase->id,'type' =>1]),
                'failure' => route('purchase-response',['id'=>$purchase->id,'type' =>2]),
                'pending' => route('purchase-response',['id'=>$purchase->id,'type' =>3]),
            ],
            'auto_return' => 'approved',
            'binary_mode' => true,
            'external_reference' => $external_reference,
            'statement_descriptor' => 'Tienda de Cafe',
            'notification_url' => route('home'),
        ]);

        $preference = collect(json_decode(json_encode($preference)));
        return $preference;
    }
}
