<?php

namespace App\Helpers;

use App\Models\Inventory;
use App\Models\ProductPricePurchase;
use App\Models\Purchase;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;

class Utility {
    public static function sendEmail($email, $model)
    {
        Mail::to($email)->send($model);
    }
    
    public static function saveImage($image, $folder)
    {
        $name = md5($image . microtime()) . '.' . $image->extension();
        $image->storeAs('public/images/'.$folder, $name);
        return $name;
    }

    public static function deleteImage($image, $folder)
    {
        Storage::delete('public/images/'.$folder.'/'.$image);
        return true;
    }

    public static function quantity($product_id)
    {
        $plus = Inventory::
        // join('clothing_sizes_products','clothing_sizes_products.id','=','inventories.clothing_sizes_product_id')
        where([
            ['inventories.inventory_type_id', '=', 1],
            ['inventories.product_id', '=', $product_id],
            // ['clothing_sizes_products.product_id', '=', $product_id],
            // ['clothing_sizes_products.id','=',$size_id]
        ])->sum('quantity');
        $minus = 
        Inventory::
        // join('clothing_sizes_products','clothing_sizes_products.id','=','inventories.clothing_sizes_product_id')
        where([
            ['inventories.inventory_type_id', '=', 2],
            ['inventories.product_id', '=', $product_id],
            // ['clothing_sizes_products.product_id', '=', $product_id],
            // ['clothing_sizes_products.id','=',$size_id]
        ])->sum('quantity');

        $purchases = ProductPricePurchase::join('purchases', 'purchases.id', '=', 'product_price_purchases.purchase_id')
        ->join('product_prices', 'product_prices.id', '=', 'product_price_purchases.product_price_id')
        ->join('products', 'products.id', '=', 'product_prices.product_id')
        // ->join('clothing_sizes_products','clothing_sizes_products.id','=','product_price_purchases.clothing_sizes_product_id')
        ->where([
            ['product_prices.product_id', '=', $product_id],
            // ['clothing_sizes_products.product_id', '=', $product_id],
            // ['clothing_sizes_products.id','=',$size_id]
        ])
        ->whereIn('purchases.status_id', [10, 13, 15, 16, 17, 18, 24])
        ->select('product_price_purchases.*', 'products.name', 'purchases.status_id','purchases.id as purchase_id')
        ->get();
        // info($purchases);

        // $purchases = 0;
        return $plus - $minus - $purchases->sum('quantity');
    }

    public static function searchPurchase()
    {
        // $deviceId = '';
        // if (!request()->cookie('device_id')) {
        //     $deviceId = Str::uuid();
        //     Cookie::queue('device_id', $deviceId, 60 * 24 * 30);
        // } else {
        //     $deviceId = request()->cookie('device_id');
        // }


        // info(request()->header('User-Agent'));
        $ip = null;
        // $arpScan = null;
        
        // if (auth()->check()) {
        //     // return redirect()->route('customer.registration',['product' => $this->product->id]);
        //     $purchase = Purchase::where([
        //         ['user_id','=',auth()->user()->id],
        //         ['status_id','=',19]
        //     ])->first();
        // }else{
        //     // $ip = request()->ip();
        //     // $arpScan = exec("arp -a $ip");
            
        //     $purchase = Purchase::join('users','users.id','=','purchases.user_id')->where([
        //         // ['user_id','=',auth()->user()->id],
        //         // ['purchases.ip','=',$ip],
        //         // ['purchases.mac','=',$deviceId],
        //         ['purchases.status_id','=',19],
        //         ['users.role_id','=',3]
        //     ])->select('purchases.*')->first();
        // }

        $purchase = Purchase::where([
            ['user_id','=',auth()->user()->id],
            ['status_id','=',19]
        ])->first();

        if (is_null($purchase)) {
            $purchase = Purchase::create([
                    // 'home_delivery' => 1,
                    // 'invoice'       => 0,
                    'user_id'       => auth()->user()->id,
                    'status_id'     => 19,
                    'token'         => (string) Str::uuid(),
                    // 'ip'            => $ip,
                    // 'mac'           => $arpScan,
                ]);
        }
        // info($purchase);
        // return ['purchase' => $purchase, 'ip' => $ip, 'mac' => $deviceId];
        return ['purchase' => $purchase];
    }

    public static function validateProductStatus($products)
    {
        foreach ($products as $cart) {
            if ($cart->product_price->product->status_id == 5) $cart->delete();
        }
    }
}