<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Models\Address;
use App\Models\AddressPurchase;
use Illuminate\Http\Request;

class AddressController extends Controller
{
    //
    public function index()
    {
        //
        $section = 1;
        return view('pages.client.address', compact('section'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        if (count(auth()->user()->addresses) >= 5) {
            session()->flash('status', 'Solo se puede generar 5 direcciones por persona.');
            return redirect()->route('compras.index');
        }
        $section = 2;
        return view('pages.client.address', compact('section'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Address $direccione)
    {
        //
        if ($direccione->user_id != auth()->user()->id || $direccione->status_id == 23) {
            abort(404);
        }

        $purchases = AddressPurchase::join('purchases','purchases.id','=','address_purchases.purchase_id')
        ->where('address_purchases.address_id',$direccione->id)
        ->whereIn('purchases.status_id',[10, 13, 15, 16, 17, 24])
        ->select('address_purchases.*','purchases.status_id')->count();
        
        if ($purchases > 0) {
            session()->flash('server', 'Esta dirección está designada a un pedido en proceso y no puede ser editada. Por favor, espere a que finalice el proceso para realizar cambios.');
            return redirect()->route('direcciones.index');
        }

        $section = 3;
        return view('pages.client.address', compact('section', 'direccione'));
    }
}
