<?php

namespace App\Livewire\Admin\Comment;

use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Edit extends Component
{
    public $product, $comment, $client, $description, $rating;

    public function render()
    {
        return view('livewire.admin.comment.edit');
    }

    public function mount()
    {
        $this->client = $this->comment->client;
        $this->description = $this->comment->description;
        $this->rating = $this->comment->rating;
        $this->product = $this->comment->product;
    }

    public function save()
    {
        $this->validate([
            'client'        => 'required|string|min:4|max:200',
            'description'   => 'required|string|min:4|max:50000',
            'rating'        => 'required|integer|min:1|max:5',
        ]);
        
        DB::beginTransaction();
        try {
            //
            $this->comment->update([
                'client'        => $this->client,
                'description'   => $this->description,
                'rating'        => $this->rating,
            ]);

            DB::commit();
            session()->flash('status', 'Los datos se guardaron correctamente.');
            return redirect()->route('comments.index',$this->product);
        } catch (\Throwable $th) {
            DB::rollBack();
            info($th->getMessage());
        }
    }
}
