<?php

namespace App\Livewire\Admin\Comment;

use App\Models\Comment;
use Livewire\Component;

class Index extends Component
{
    public $product, $search, $modalOpen;

    public function render()
    {
        $comments = $this->searchElement();
        return view('livewire.admin.comment.index',['comments'=>$comments]);
    }

    public function searchElement()
    {
        return Comment::where('client','like', '%' . $this->search . '%')->paginate(10);
    }

    public function mount()
    {
        info($this->product);
    }

    public function closeModal()
    {
        $this->modalOpen = false;
    }

    public function deletedComment($id)
    {
        $comment = Comment::find($id);
        $comment->delete();
    }
}
