<?php

namespace App\Livewire\Admin\Configuration;

use App\Models\ContactDetails;
use Livewire\Component;

class Index extends Component
{
    public $details;
    public function render()
    {
        return view('livewire.admin.configuration.index');
    }
    
    public function mount()
    {
        $this->searchDetails();
    }

    public function changeStatus($id, $status)
    {
        $detail = ContactDetails::find($id);
        if (!is_null($detail)) {
            $detail->update(['status_id' => $status]);
            $this->searchDetails();
        }
    }

    public function searchDetails()
    {
        $this->details = ContactDetails::all();
    }
}
