<?php

namespace App\Livewire\Admin\Inventory;

use App\Helpers\Utility;
use App\Models\ClothingSize;
use App\Models\Inventory;
use App\Models\InventoryType;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Edit extends Component
{
    public $product, $inventoryTypes, $inventory_type_id, $quantity, $clothing_sizes_data, $size_id;

    public function render()
    {
        return view('livewire.admin.inventory.edit');
    }

    public function mount()
    {
        // $this->product->price = ProductPrice::orderBy('id','DESC')->where([
        //     ['product_id','=',$this->product->id],
        //     ['status_id','=',8]
        // ])->first()->price;
        // info($this->product);
        $this->inventoryTypes = InventoryType::all();
        $this->inventory_type_id = $this->inventoryTypes->first()->id;
        // $clothing_sizes = $this->product->clothingSizesProducts->where('status_id','=',8)->pluck('clothing_size_id');<
        // $this->clothing_sizes_data = ClothingSize::whereIn('id',$this->product->clothingSizesProducts->where('status_id','=',8)->pluck('clothing_size_id'))->get();
        // $this->size_id = $this->clothing_sizes_data->first()->id;
        // info($this->clothing_sizes_data);
        $this->inventory();
    }

    public function inventory()
    {
        $this->product->quantity = Utility::quantity($this->product->id);
        // $plus = Inventory::where([
        //     ['inventory_type_id','=',1],
        //     ['product_id','=',$this->product->id]
        // ])->sum('quantity');
        // $minus = Inventory::where([
        //     ['inventory_type_id','=',2],
        //     ['product_id','=',$this->product->id]
        // ])->sum('quantity');

        // $purchases = ProductPricePurchase::join('purchases','purchases.id','=','product_price_purchases.purchase_id')
        // ->join('product_prices','product_prices.id','=','product_price_purchases.product_price_id')
        // ->join('products','products.id','=','product_prices.product_id')
        // ->where([
        //     ['product_prices.product_id','=',$this->product->id],
        // ])
        // ->whereIn('purchases.status_id',[12,17,18,19,20])
        // ->select('product_price_purchases.*','products.name','purchases.status_id')->count();

        // $this->product->quantity = $plus-$minus-$purchases;
    }

    public function save()
    {
        $this->validate([
            'quantity' => 'required|integer|min:1|max:99999',
            'inventory_type_id' => 'required|integer|exists:inventory_types,id',
            // 'size_id' => 'required|integer|exists:clothing_sizes,id'
        ]);
        $this->inventory();
        if ($this->quantity > $this->product->quantity && $this->inventory_type_id > 1) return $this->addError('quantity','La cantidad es mayor de lo que contiene actualmente el inventario.');

        DB::beginTransaction();
        try {
            //
            $size_id = $this->product->clothingSizesProducts->where('status_id','=',8)->where('clothing_size_id','=',$this->size_id)->first();

            Inventory::create([
                'quantity'      => $this->quantity,
                'product_id'    => $this->product->id,
                // 'clothing_sizes_product_id' => $size_id->id,
                'inventory_type_id' => $this->inventory_type_id,
            ]);

            DB::commit();
            session()->flash('status', 'Los datos se guardaron correctamente.');
            return redirect()->route('products.index');
        } catch (\Throwable $th) {
            DB::rollBack();
            info($th->getMessage());
        }
    }
}