<?php

namespace App\Livewire\Admin\Product;

use App\Helpers\Utility;
use App\Models\Category;
// use App\Models\ClothingSize;
// use App\Models\ClothingSizesProduct;
use App\Models\MeasurementUnit;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\ProductPrice;
use App\Models\Subcategory;
// use App\Rules\ExistClothingSizeRule;
// use App\Rules\IntegerClothingSizeRule;
// use App\Rules\RepeatClothingSizeRule;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Livewire\WithFileUploads;

class Create extends Component
{
    use WithFileUploads;
    
    public $name, $categories, $category_id, $subcategories, $subcategory_id, $description, $code, $price, $iva;
    public $measurement_units, $measurement_unit_id, $image, $clothing_sizes_data, $clothing_sizes = [], $clothing_size_id;
    public $contents, $introduction, $origin, $roasting;

    public function render()
    {
        return view('livewire.admin.product.create');
    }

    public function mount()
    {
        // $this->iva = 1;
        $this->measurement_units = MeasurementUnit::all();
        $this->measurement_unit_id = $this->measurement_units->first()->id;
        $this->categories = Category::all();
        $this->category_id = $this->categories->first()->id;
        // $this->subcategories = Subcategory::where('category_id',$this->subcategory_id)->get();
        // $this->clothing_sizes_data = ClothingSize::all();
    }

    public function selectCategory(){
        $this->subcategories = Subcategory::where('category_id',$this->category_id)->get();
        $this->subcategory_id = $this->subcategories->first()->id;
    }

    public function save()
    {
        $this->validate([
            'name'          => 'nullable|string|min:4|max:200',
            'description'   => 'nullable|string|max:200',
            'contents'      => 'required|numeric|min:0|max:99999999',
            'introduction'  => 'required|string|max:200',
            'origin'        => 'required|string|max:200',
            'roasting'      => 'required|string|max:200',
            // 'quantity'    => 'required|integer|min:0|max:99999',
            // 'code'  => 'nullable|string|max:100',
            'price'         => 'required|numeric|min:0|max:999999',
            // 'iva'   => 'required|boolean',
            'measurement_unit_id' => 'required|integer|exists:measurement_units,id',
            // category_id
            'category_id'   => 'required|integer|exists:categories,id',
            'image'         => 'required|image|mimes:jpeg,png,jpg|max:2048',
            // 'clothing_sizes' => ['array','min:1','max:'.count($this->clothing_sizes_data), new RepeatClothingSizeRule, new IntegerClothingSizeRule, new ExistClothingSizeRule($this->clothing_sizes_data)],
        ]);
        
        DB::beginTransaction();
        try {
            //
            $product = Product::create([
                'name'          => $this->name,
                'description'   => $this->description,
                'contents'      => $this->contents,
                'introduction'  => $this->introduction,
                'origin'        => $this->origin,
                'roasting'      => $this->roasting,
                // 'quantity'      => $this->quantity,
                // 'code'          => $this->code,
                'status_id'     => 4,
                // 'subcategory_id' => $this->subcategory_id,
                'category_id'   => $this->category_id,
                // 'iva'           => $this->iva,
                'measurement_unit_id' => $this->measurement_unit_id,
            ]);

            ProductPrice::create([
                'price'         => $this->price,
                'product_id'    => $product->id,
                'status_id'     => 6,
            ]);

            $image = Utility::saveImage($this->image,'gallery');
            ProductImage::create([
                'path'          => $image,
                'product_id'    => $product->id
            ]);

            // Inventory::create([
            //     'quantity'  => $this->quantity,
            //     'product_id'=> $product->id,
            //     'inventory_type_id' => 1,
            // ]);

            // foreach ($this->clothing_sizes as $key) {
            //     ClothingSizesProduct::create([
            //         'product_id' => $product->id,
            //         'clothing_size_id' => $key,
            //         'status_id' => 8
            //     ]);
            // }

            DB::commit();
            session()->flash('status', 'Los datos se guardaron correctamente.');
            // return redirect()->route('image-gallery.edit',$product);
            return redirect()->route('products.index');

        } catch (\Throwable $th) {
            DB::rollBack();
            info($th->getMessage());
        }
    }
}
