<?php

namespace App\Livewire\Admin\Product;

use App\Models\Product;
use Illuminate\Pagination\Paginator;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination; 

    public $productos, $product, $search = '';
    public $modalOpen = false;
    // protected $paginationTheme = 'tailwind';

    // public function updatingPage()
    // {
    //     // Resetear a la primera página cuando cambian otros filtros
    //     $this->resetPage();
    // }

    public function render()
    {
        $products = $this->searchElement();
        // info($products);
        return view('livewire.admin.product.index', ['products' => $products]);
    }


    public function searchElement()
    {
        return Product::query()
            ->join('categories', 'products.category_id', '=', 'categories.id')
            ->when($this->search, function ($query) {
                $query->where(function ($query) {
                    $query
                        ->where('products.name', 'like', '%' . $this->search . '%')
                        ->orWhere('products.description', 'like', '%' . $this->search . '%')
                        ->orWhere('categories.name', 'like', '%' . $this->search . '%');
                });
            })
            ->select('products.*') // Evita conflictos con columnas duplicadas
            ->paginate(10); // Cambia el número de items por página según necesites
    }

    // public function boot()
    // {
    //     Paginator::useTailwind();
    // }

    public function selectedProduct($id)
    {
        $this->product = Product::find($id);
        $this->modalOpen = true;
    }

    public function closeModal()
    {
        $this->modalOpen = false;
    }
}
