<?php

namespace App\Livewire\Admin\Purchase;

use App\Models\Purchase;
use App\Models\Status;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;
    
    public $orders, $status_id, $status, $status_selected, $selectedValues = [];

    public function render()
    {
        $orderes = $this->searchElement();
        return view('livewire.admin.purchase.index',['orderes' => $orderes]);
    }
    
    public function mount()
    {
        $this->status_id = 12;
        $this->status = Status::orderBy('name','ASC')->where('status_type_id',5)->get();
    }

    public function searchElement()
    {
        // $this->
        return Purchase::where([
            ['status_id','=',$this->status_id]
        ])->orderBy('updated_at','ASC')->paginate(10);
    }
}
