<?php

namespace App\Livewire\Admin\Suggestion;

use App\Models\Suggestion;
use Livewire\Component;

class Index extends Component
{
    public $product, $search, $modalOpen;

    public function render()
    {
        $suggestions = $this->searchElement();
        info($suggestions);
        return view('livewire.admin.suggestion.index',['suggestions' => $suggestions]);
    }

    public function searchElement()
    {
        return Suggestion::join('products','products.id','=','suggestions.suggestion_id')
        ->where('products.name','like', '%' . $this->search . '%')
        ->where('suggestions.product_id',$this->product->id)
        ->select('products.*','suggestions.id as suggestion_id')->paginate(10);
    }

    public function deletedComment($id)
    {
        $comment = Suggestion::find($id);
        $comment->delete();
    }
}
