<?php

namespace App\Livewire\Client;

use App\Helpers\Utility;
use Livewire\Component;
use Livewire\Attributes\On; 

class Cart extends Component
{
    public $count = 0;

    public function render()
    {
        return view('livewire.client.cart');
    }

    #[On('check-cart')] 
    public function mount()
    {
        $search = Utility::searchPurchase();
        $purchase = $search['purchase'];

        $this->count = is_null($purchase) ? 0 : count($purchase->product_price_purchases);
    }
}
