<?php

namespace App\Livewire\Client\Shopping;

use App\Models\Purchase;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;
    
    public $search, $modalOpen = false, $delete_id, $purchase;

    public function render()
    {
        $shopping = $this->searchElement();
        return view('livewire.client.shopping.index',['shopping' => $shopping]);
    }

    public function searchElement()
    {
        return Purchase::where([
            // ['name','like', '%' . $this->search . '%'],
            ['user_id','=',auth()->user()->id],
            ['status_id','!=',19]
        ])->orderBy('created_at','DESC')
        ->paginate(10);
    }

    public function deletePurchase(){
        // info($address_id);
        if (!is_null($this->purchase)) {
            $this->purchase->update(['status_id'=>11]);
            $this->modalOpen = false;
        }
    }

    public function openModal($delete_id){
        $this->purchase = Purchase::find($delete_id);
        $this->modalOpen = true;
    }
    public function closeModal()
    {
        $this->modalOpen = false;
    }
}