<?php

namespace App\Livewire\Dashboard;

use App\Helpers\MercadoPago;
use App\Helpers\Utility;
use App\Models\ContactDetails;
use App\Models\ProductPricePurchase;
use Illuminate\Support\Str;
use Livewire\Component;

class Checkout extends Component
{
    public $purchase, $products = [], $items = [], $total = 0, $clothes = 0, $shipping, $user, $preference;

    public function render()
    {
        return view('livewire.dashboard.checkout');
    }

    public function mount()
    {
        // $this->purchase = Purchase::where([
        //     ['user_id', '=', auth()->user()->id],
        //     ['status_id', '=', 19]
        // ])->first();

        // $search = Utility::searchPurchase();
        // $this->purchase = $search['purchase'];
        // if (is_null($this->purchase)) {
        //     session()->flash('server', 'El Carrito de Compras esta Vacío.');
        //     return redirect()->route('cart');
        // }

        // if (!auth()->check()) {
        //     if ($this->purchase->updated != 1) {
        //         session()->flash('server', 'Registre Datos Personales en el Carrito de Compras.');
        //         return redirect()->route('cart');
        //     }
        //     // // Registrar en logs el valor de la sesión para depuración
        //     // info(session('checkout'));

        //     // // Si no existe la sesión o su valor no es true, redirigir al carrito
        //     // if (!session()->has('checkout') || session('checkout') != true) {
        //     //     session()->flash('server', 'Registre Datos Personales en el Carrito de Compras.');
        //     //     return redirect()->route('cart');
        //     // }
        // }
        // $this->user = $this->purchase->user;

        // if (is_null($this->purchase) || is_null($this->purchase->address_purchase)) return redirect()->route('cart');

        // $this->shipping = ContactDetails::find(8)->resource;
        $this->shipping = $this->purchase->shipping;
        $this->listProducts();
        if (count($this->products) == 0) {
            session()->flash('server', 'El Carrito de Compras esta Vacío.');
            return redirect()->route('cart');
        }
        // info($this->items);
        $preference = MercadoPago::preference($this->items, $this->purchase);
        $this->preference = $preference;
        // info($this->preference);
        // info($this->preference['id']);
        // info($this->purchase->address_purchase);
        // info($this->products);
    }

    public function listProducts()
    {
        // $this->products = is_null($this->purchase) ? [] : $this->purchase->product_price_purchases;
        Utility::validateProductStatus(is_null($this->purchase) ? [] : $this->purchase->product_price_purchases);
        $this->products = is_null($this->purchase) ? [] : ProductPricePurchase::where('purchase_id', $this->purchase->id)->get();

        foreach ($this->products as $cart) {
            $name = 
            // (is_null($cart->product_price->product->name) ? '' : $cart->product_price->product->name) . ' - '.
                            $cart->product_price->product->category->name;
                            // .'('.$cart->product_price->product->contents
                            // .$cart->product_price->product->measurement_unit->code.')';
            array_push($this->items, [
                'id'    => $cart->id,
                'title' => Str::limit($name, 50),
                'quantity'      => (int) $cart->quantity,
                'unit_price'    => (double) $cart->product_price->price,
                'currency_id'   => 'MXN',
                'category_id'   => 'others',
                'description'   => Str::limit($cart->product_price->product->description, 120)
            ]);
            // info($cart->product_price->product->id);
            // info($cart->clothing_sizes_product_id);
            // info($cart->product_price->product->quantity($cart->product_price->product->id,$cart->clothing_sizes_product_id));
            // info($cart->product_price->price);
            $this->clothes += ($cart->product_price->price * $cart->quantity);
        }
        $this->total = $this->clothes + $this->purchase->shipping;
        // $this->purchase->update(['shipping' => $this->shipping]);
    }
}
