<?php

namespace App\Livewire\Dashboard;

use App\Helpers\Utility;
use App\Mail\ContactMail;
use App\Models\ContactDetails;
use Livewire\Component;

class Contact extends Component
{
    public $contact_details, $full_name, $subject, $description, $email, $show_alert = false;
    public $showModal = false;

    public function render()
    {
        return view('livewire.dashboard.contact');
    }

    public function mount()
    {
        $this->contact_details = ContactDetails::join('contact_data_types', 'contact_data_types.id', '=', 'contact_details.contact_data_type_id')
            ->where('contact_data_types.contact_type_id', 2)
            ->where('status_id', 20)
            ->select('contact_details.*')->get();
    }

    public function save()
    {
        $this->validate([
            'full_name'     => 'required|string|min:3|max:255',
            'email'         => 'required|email|min:3|max:255',
            'subject'       => 'required|string|min:3|max:255',
            'description'   => 'required|string|min:3|max:3000',
        ]);

        Utility::sendEmail($this->contact_details->where('id',6)->first()->resource, new ContactMail($this->full_name, $this->email, $this->subject, $this->description));
        $this->full_name = null;
        $this->subject = null;
        $this->description = null;
        $this->email = null;
        $this->showModal = true;
        // session()->flash('success', 'Contraseña actualizada correctamente.');
        // return redirect()->route('login');
    }
}
