<?php

namespace App\Livewire\Dashboard;

use App\Models\ContactDetails;
use Livewire\Component;

class Footer extends Component
{
    public $contact_details;

    public function render()
    {
        return view('livewire.dashboard.footer');
    }

    public function mount()
    {
        $this->contact_details = ContactDetails::join('contact_data_types', 'contact_data_types.id', '=', 'contact_details.contact_data_type_id')
            ->whereIn('contact_data_types.contact_type_id', [1,2])
            ->where('status_id', 20)
            ->select('contact_details.*')->get();
    }
}
