<?php

namespace App\Livewire\Dashboard;

use App\Models\Category;
use App\Models\Product;
use Livewire\Component;

class Products extends Component
{
    public $products, $categories, $category, $select;

    public function render()
    {
        return view('livewire.dashboard.products');
    }
    
    public function mount()
    {
        // $this->products = Product::orderBy('category_id','ASC')->get();
        $this->categories = Category::all();
        $this->searchProduct($this->categories->first()->id);
        $this->category = $this->categories->first();
        $this->select = $this->categories->first()->id;
    }

    public function searchProduct($category_id)
    {
        $this->products = Product::orderBy('category_id','ASC')
        ->where([
            ['category_id','=',$category_id],
            ['status_id','=',4]
        ])->get();
        $this->category = $this->categories->where('id',$category_id)->first();
        $this->select = $category_id;
    }
}
