<?php

namespace App\Livewire\User;

use App\Helpers\Utility;
use App\Mail\NewUserMail;
use App\Models\Person;
use App\Models\Role;
use App\Models\Status;
use App\Models\User;
use App\Rules\StatusRule;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Livewire\Component;

class Edit extends Component
{
    public $user, $roles, $first_name, $second_name, $first_surname, $second_surname, $phone, $birth_date, $roleId, $email, $status, $status_id;

    public function render()
    {
        return view('livewire.user.edit');
    }

    public function mount()
    {
        $this->roles = Role::where('id', '!=', 2)->get();
        $this->roleId = $this->roles->first()->id;
        $this->first_name = $this->user->person->first_name;
        $this->second_name = $this->user->person->second_name;
        $this->first_surname = $this->user->person->first_surname;
        $this->second_surname = $this->user->person->second_surname;
        $this->phone = $this->user->person->phone;
        $this->birth_date = $this->user->person->birth_date;
        $this->email = $this->user->email;
        $this->roleId = $this->user->role_id;
        $this->status = Status::where('status_type_id', 1)->get();
        $this->status_id = $this->user->status_id;
    }

    public function save()
    {
        $this->validate([
            'first_name' => 'required|string|max:100',
            'second_name' => 'nullable|string|max:100',
            'first_surname' => 'required|string|max:100',
            'second_surname' => 'nullable|string|max:100',
            'phone' => 'required|integer|regex:/^\d{10}$/',
            'birth_date' => 'required|date_format:Y-m-d',
            'email' => 'required|string|email|max:200|unique:users,email,' . $this->user->id,
            'roleId' => 'required|integer|exists:roles,id',
            'status_id' => ['required', 'integer', new StatusRule(1)],
            // 'sales_point_id'    => $this->role_id == 2 ? 'required|integer|exists:sales_points,id' : ''
        ]);

        DB::beginTransaction();
        try {
            $this->user->person->update([
                'first_name' => $this->first_name,
                'second_name' => $this->second_name,
                'first_surname' => $this->first_surname,
                'second_surname' => $this->second_surname,
                'phone' => $this->phone,
                'birth_date' => $this->birth_date,
            ]);

            // $password = Str::random(10);
            $this->user->update([
                'email' => $this->email,
                // 'password'  => Hash::make($password),
                'status_id' => $this->status_id,
                'role_id' => $this->roleId,
                // 'person_id' => $employee->id,
            ]);

            // Utility::sendEmail($this->email, new NewUserMail($user, $password));

            DB::commit();
            session()->flash('status', 'Los datos se guardaron correctamente.');
            return redirect()->route('users.index');
        } catch (\Throwable $th) {
            DB::rollBack();
        }
    }
}
