<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PurchaseCompletedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $purchase, $shipping, $total, $clothes;

    /**
     * Create a new message instance.
     */
    public function __construct($purchase)
    {
        //
        $this->purchase = $purchase;
        $this->shipping = $this->purchase->shipping;
        $this->listProducts();
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Detalls de Pago',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.purchase-completed',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }

    public function listProducts()
    {
        $products = is_null($this->purchase) ? [] : $this->purchase->product_price_purchases;
        foreach ($products as $cart) {
            // info($cart->product_price->product->id);
            // info($cart->clothing_sizes_product_id);
            // info($cart->product_price->product->quantity($cart->product_price->product->id,$cart->clothing_sizes_product_id));
            // info($cart->product_price->price);
            $this->clothes += ($cart->product_price->price * $cart->quantity);
        }
        $this->total = $this->clothes + $this->shipping;
    }
}
