<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    use HasFactory;
    protected $table = 'addresses';
    protected $guarded = ['id'];

    public function setMainStreetAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['main_street'] = mb_convert_case($value, MB_CASE_TITLE);
    }
    public function setBetweenStreetsAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['between_streets'] = mb_convert_case($value, MB_CASE_TITLE);
    }
    public function setReferenceAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['reference'] = mb_convert_case($value, MB_CASE_TITLE);
    }
    public function setNeighborhoodAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['neighborhood'] = mb_convert_case($value, MB_CASE_TITLE);
    }

    public function purchases()
    {
        return $this->hasMany(AddressPurchase::class, 'address_id', 'id');
    }
}
