<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Person extends Model
{
    use HasFactory;
    protected $table = 'people';
    protected $guarded = ['id'];

    public function setFirstNameAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['first_name'] = mb_convert_case($value, MB_CASE_TITLE);
    }
    public function setSecondNameAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['second_name'] = mb_convert_case($value, MB_CASE_TITLE);
    }
    public function setFirstSurnameAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['first_surname'] = mb_convert_case($value, MB_CASE_TITLE);
    }
    public function setSecondSurnameAttribute($value)
    {
        mb_internal_encoding('UTF-8');
        $this->attributes['second_surname'] = mb_convert_case($value, MB_CASE_TITLE);
    }
    
    public function user()
    {
        return $this->belongsTo(User::class, 'id', 'person_id');
    }
}
