<?php

namespace App\Models;

use App\Helpers\Utility;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $table = 'products';
    protected $guarded = ['id'];

    public function status()
    {
        return $this->belongsTo(Status::class, 'status_id', 'id');
    }

    public function price()
    {
        return $this->belongsTo(ProductPrice::class, 'id', 'product_id')->where('status_id',6);
    }

    public function quantity()
    {
        return Utility::quantity($this->id);
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function measurement_unit()
    {
        return $this->belongsTo(MeasurementUnit::class, 'measurement_unit_id', 'id');
    }

    public function subcategory()
    {
        return $this->belongsTo(Subcategory::class, 'subcategory_id', 'id');
    }

    public function clothingSizesProducts()
    {
        return $this->hasMany(ClothingSizesProduct::class, 'product_id', 'id');
    }

    public function images()
    {
        return $this->hasMany(ProductImage::class, 'product_id', 'id')->orderBy('id','ASC');
    }

    public function image()
    {
        if (count($this->images) > 0) return ($this->images->first()->path);
        else return null;
    }

    public function suggestions()
    {
        return $this->hasMany(Suggestion::class, 'product_id', 'id');
    }
}