<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ContactRule implements ValidationRule
{
    protected $validation;

    public function __construct($validation)
    {
        $this->validation = $validation;
    }
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        //
        info($this->validation);
        switch ($this->validation) {
            case 1:
                if (!filter_var($value, FILTER_VALIDATE_URL)) $fail('La cadena no es una URL válida.');
                break;
            case 2:
                if (!preg_match("/^\d{10}$/", $value)) $fail('El número de teléfono no es válido.');
                break;
            case 3:
                if (!filter_var($value, FILTER_VALIDATE_EMAIL)) $fail('El correo electrónico no es válido.');
                break;
            case 4:
                if (strlen($value) > 220) $fail('El texto proporcionado excede los 220 caracteres');
                break;
            case 5:
                if (strlen($value) > 600) $fail('El texto proporcionado excede los 600 caracteres');
                break;
            case 6:
                info($value);
                if (!preg_match('/^[0-9]{1,4}$/', $value)) $fail('El número no es válido. Debe cumplir contener solo dígitos del 0 al 9, tener entre 1 y 4 caracteres, y no incluir números negativos, decimales ni caracteres no válidos.');
                break;
            case 7:
                if (strlen($value) > 60000) $fail('El texto proporcionado excede los 600 caracteres');
                break;
            default:
                # code...
                break;
        }
    }
}
