<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ExistClothingSizeRule implements ValidationRule
{
    public $clothing_size;

    public function __construct($clothing_size)
    {
        $this->clothing_size = $clothing_size;
    }
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        //
        $data = $this->clothing_size->pluck('id')->toArray();
        foreach ($value as $row) {
            if (!in_array($row,$data)) $fail('El id de la talla no es permitido.');
        }
    }
}
