<?php

namespace App\Rules;

use App\Models\Product;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ListIndexRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        //
        foreach ($value as $item) {
            if (!array_key_exists('id', $item)) {
                $fail('La lista no contiene la estructura correcta.');
            }
        }

        foreach ($value as $item) {
            $product = Product::where([
                ['id','=',$item['id']],
                ['status_id','=','5']
            ])->first();
            if (!is_null($product)) $fail('La lista contiene el siguiente producto inactivo: '.$product->name);
        }

        // foreach ($value as $item) {
        //     if ($item['quantity'] < 1) $fail('La lista debe de tener un mínimo de 1 elemento por producto.');
        // }
    }
}
