<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class RepeatClothingSizeRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        //
        $data = array_count_values($value);

        // Filtrar las ocurrencias mayores que 1
        $repeats = array_filter($data, function($valor) {
            return $valor > 1;
        });

        if (!empty($repeats)) $fail('Se seleccionaron varias veces la misma talla.');
    }
}
