<?php

namespace App\Rules;

use App\Models\Status;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class StatusRule implements ValidationRule
{
    protected $status_type_id;

    public function __construct($status_type_id)
    {
        $this->status_type_id = $status_type_id;
    }
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        //
        $status = Status::where('status_type_id',$this->status_type_id)->where('id',$value)->first();
        if (is_null($status)) $fail('El status_id no es Correcto.');
    }
}
