<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ZipRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        //
        if (preg_match('/^\d{5}$/', $value) == 0) $fail('El código postal no contiene los dígitos necesarios.');
        // if (preg_match('/^29(0[0-9]{2}|1[0-1][0-4])$/', $value) == 0) $fail('El código postal no pertenece al municipio de Tuxtla Gutiérrez, Chiapas.');
    }
}
