<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
            $table->boolean('home_delivery')->nullable();
            $table->boolean('invoice')->nullable();
            $table->string('guide_one')->nullable();
            $table->string('guide_two')->nullable();
            $table->boolean('updated')->default(0);
            $table->string('ip')->nullable();
            $table->string('mac')->nullable();
            $table->double('shipping', 10, 2)->nullable();
            $table->string('token')->unique();
            $table->date('payment_date')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users');
            $table->unsignedBigInteger('status_id');
            $table->foreign('status_id')->references('id')->on('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};
