<?php

namespace Database\Seeders;

use App\Models\CFDICatalog;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CFDICatalogsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $data = [
            ['G01', 'Adquisición de mercancías.'],
            ['G02', 'Devoluciones, descuentos o bonificaciones.'],
            ['G03', 'Gastos en general.'],
            ['I01', 'Construcciones.'],
            ['I02', 'Mobiliario y equipo de oficina por inversiones.'],
            ['I03', 'Equipo de transporte.'],
            ['I04', 'Equipo de cómputo y accesorios.'],
            ['I05', 'Dados, troqueles, moldes, matrices y herramental.'],
            ['I06', 'Comunicaciones telefónicas.'],
            ['I07', 'Comunicaciones satelitales.'],
            ['I08', 'Otra maquinaria y equipo.'],
            ['D01', 'Honorarios médicos, dentales y gastos hospitalarios.'],
            ['D02', 'Gastos médicos por incapacidad o discapacidad.'],
            ['D03', 'Gastos funerales.'],
            ['D04', 'Donativos.'],
            ['D05', 'Intereses reales efectivamente pagados por créditos hipotecarios [casa habitación).'],
            ['D06', 'Aportaciones voluntarias al SAR.'],
            ['D07', 'Primas por seguros de gastos médicos.'],
            ['D08', 'Gastos de transportación escolar obligatorio.'],
            ['D09', 'Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones.'],
            ['D10', 'Pagos por servicios educativos [colegiaturas).'],
            ['S01', 'Sin efectos fiscales.'],
            ['CP01', 'Pagos.'],
            ['CN01', 'Nómina.'],
        ];
        foreach ($data as $item) {
            CFDICatalog::create([
                'key' => $item[0],
                'description' => $item[1],
            ]);
        }
    }
}
