<?php

namespace Database\Seeders;

use App\Models\ContactDataType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ContactDataTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $contacts = [
            ['name' => 'Facebook', 'image' => 'bt_fb.svg', 'validation' => '1', 'contact_type_id' => 1],//1
            ['name' => 'YouTube', 'image' => 'bt_yt.svg', 'validation' => '1', 'contact_type_id' => 1],//2
            ['name' => 'X', 'image' => 'bg_x.svg', 'validation' => '1', 'contact_type_id' => 1],//3

            ['name' => 'Teléfono', 'image' => 'bt_telefono.svg', 'validation' => '2', 'contact_type_id' => 2],//4
            ['name' => 'Dirección', 'image' => 'bt_ubicacion.svg', 'validation' => '4', 'contact_type_id' => 2],//5
            ['name' => 'Correo Electrónico', 'image' => 'bt_correo.svg', 'validation' => '3', 'contact_type_id' => 2],//6



            // ['name' => 'Instagram', 'image' => 'instagram.png', 'validation' => '1', 'contact_type_id' => 1],//2
            // ['name' => 'TikTok', 'image' => 'tik-tok.png', 'validation' => '1', 'contact_type_id' => 1],//3

            // ['name' => 'WhatsApp', 'image' => 'whatsapp.png', 'validation' => '2', 'contact_type_id' => 1],//5
            // ['name' => 'Teléfono', 'image' => 'telefono.png', 'validation' => '2', 'contact_type_id' => 2],//6
            
            // ['name' => 'Correo Electrónico', 'image' => 'correo.png', 'validation' => '3', 'contact_type_id' => 2],//7
            // ['name' => 'Nosotros', 'image' => 'us.png', 'validation' => '7', 'contact_type_id' => 6],//8

            // ['name' => 'Costo de Envío', 'image' => 'shipment.png', 'validation' => '6', 'contact_type_id' =>5],//9

            // ['name' => 'Terminos y Condiciones', 'image' => 'terms.png', 'validation' => '7', 'contact_type_id' =>6],//10

            
            // ['name' => 'Teléfono 2', 'image' => 'telefono.png', 'validation' => '2', 'contact_type_id' => 2],//7
            // ['name' => 'Teléfono 3', 'image' => 'telefono.png', 'validation' => '2', 'contact_type_id' => 2],//8
            
            // ['name' => 'Dirección', 'image' => 'direccion.png', 'validation' => '4', 'contact_type_id' => 2],//10
            // ['name' => 'Inicio', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 3],//11

            // ['name' => 'Titulo Estadística 1', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//13
            // ['name' => 'Porcentaje  Estadística 1', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//14
            // ['name' => 'Titulo Estadística 2', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//15
            // ['name' => 'Porcentaje  Estadística 2', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//16
            // ['name' => 'Titulo Estadística 3', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//17
            // ['name' => 'Porcentaje  Estadística 3', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//18
            // ['name' => 'Titulo Estadística 4', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//19
            // ['name' => 'Porcentaje  Estadística 4', 'image' => 'home.png', 'validation' => '5', 'contact_type_id' => 4],//20
        ];
        foreach ($contacts as $contact) {
            ContactDataType::create([
                'name' => $contact['name'],
                'image' => $contact['image'],
                'validation'  => $contact['validation'],
                'contact_type_id' => $contact['contact_type_id'],
            ]);
        }
    }
}
