<?php

namespace Database\Seeders;

use App\Models\ContactDetails;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ContactDetailsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $contacts = [
            ['resource' => 'https://www.facebook.com/CafeFincaMonteVerde', 'contact_data_type_id' => 1, 'status_id' => '20'],
            ['resource' => 'https://www.youtube.com/@fincamonteverde', 'contact_data_type_id' => 2, 'status_id' => '20'],
            ['resource' => 'https://x.com/fincamonteverde', 'contact_data_type_id' => 3, 'status_id' => '20'],
            
            ['resource' => '9616670239', 'contact_data_type_id' => 4, 'status_id' => '20'],
            ['resource' => 'Carretera Raymundo Enríquez 280 Col el Arenal Campestre C.P.:29059', 'contact_data_type_id' => 5, 'status_id' => '20'],
            ['resource' => 'selene@fincamonteverde.com', 'contact_data_type_id' => 6, 'status_id' => '20'],
            
            // ['resource' => '', 'contact_data_type_id' => 3, 'status_id' => '21'],
            // ['resource' => '9612040096', 'contact_data_type_id' => 5, 'status_id' => '20'],

            // ['resource' => '9612040096', 'contact_data_type_id' => 6, 'status_id' => '20'],
            // // ['resource' => '9616163390', 'contact_data_type_id' => 7, 'status_id'=> '20'],
            // // ['resource' => '9611660112', 'contact_data_type_id' => 8, 'status_id'=> '20'],

            // ['resource' => '', 'contact_data_type_id' => 7, 'status_id' => '20'],
            // ['resource' => 'Nuestro objetivo es ofrecerte piezas que te inspiren a brillar y sentirte bien en cada momento importante de tu vida.', 'contact_data_type_id' => 8, 'status_id' => '20'],

            // ['resource' => '50', 'contact_data_type_id' => 9, 'status_id' => '20'],
            // ['resource' => $terms, 'contact_data_type_id' => 10, 'status_id' => '20'],
            // ['resource' => 'https://twitter.com/clothesrapsody', 'contact_data_type_id' => 11, 'status_id' => '20'],
            // ['resource' => '', 'contact_data_type_id' => 4, 'status_id' => '20'],

            // ['resource' => 'Calle 1ra Oriente Norte 1081, Col. La Pimienta, Tuxtla Gutiérrez, México', 'contact_data_type_id' => 10, 'status_id'=> '20'],
            // ['resource' => 'Somos una agencia de publicidad 360, donde nuestro objetivo es la creación y ejecución de estrategias en campañas mediáticas para medios tradicionales y digitales; análisis de segmentación mediante estudios de mercado; producto-servicio mediante mistery shopper; imagen e identidad corporativa; contando con servicio integral para hacer campañas de éxito.', 'contact_data_type_id' => 11, 'status_id'=> '20'],
            // ['resource' => 'Somos una agencia de publicidad 360, donde nuestro objetivo es la creación y ejecución de estrategias en campañas mediáticas para medios tradicionales y digitales; análisis de segmentación mediante estudios de mercado; producto-servicio mediante mistery shopper; imagen e identidad corporativa; contando con servicio integral para hacer campañas de éxito.', 'contact_data_type_id' => 12, 'status_id'=> '20'],

            // ['resource' => 'Clientes felices', 'contact_data_type_id' => 13, 'status_id'=> '20'],
            // ['resource' => '40K', 'contact_data_type_id' => 14, 'status_id'=> '20'],
            // ['resource' => 'Proyectos completados', 'contact_data_type_id' => 15, 'status_id'=> '20'],
            // ['resource' => '40K', 'contact_data_type_id' => 16, 'status_id'=> '20'],
            // ['resource' => 'Miembros MARKA', 'contact_data_type_id' => 17, 'status_id'=> '20'],
            // ['resource' => '40K', 'contact_data_type_id' => 18, 'status_id'=> '20'],
            // ['resource' => 'Productos digitales', 'contact_data_type_id' => 19, 'status_id'=> '20'],
            // ['resource' => '40K', 'contact_data_type_id' => 20, 'status_id'=> '20'],
        ];
        foreach ($contacts as $contact) {
            ContactDetails::create([
                'resource' => $contact['resource'],
                'contact_data_type_id' => $contact['contact_data_type_id'],
                'status_id' => $contact['status_id'],
            ]);
        }
    }
}
