<?php

namespace Database\Seeders;

use App\Models\MeasurementUnit;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MeasurementUnitsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        mb_internal_encoding('UTF-8');
        MeasurementUnit::create([
            'name' => mb_convert_case('Kilogramos' , MB_CASE_TITLE),
            'code' => mb_convert_case('KG' , MB_CASE_TITLE),
        ]);

        MeasurementUnit::create([
            'name' => mb_convert_case('Gramos' , MB_CASE_TITLE),
            'code' => mb_convert_case('G' , MB_CASE_TITLE),
        ]);
    }
}
