<?php

namespace Database\Seeders;

use App\Models\Inventory;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\ProductPrice;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $products = [
            [
                'name' => 'Variedad Marsellesa',
                'description' => 'Café gourmet para cafeteras o clientes exigentes.',
                'contents' => '500',
                'introduction' => 'Molido',
                'origin' => 'Jaltenango Chiapas | 1300 msnm',
                'roasting' => 'Medio',
                'category_id' => '1',
                'measurement_unit_id' => '2',
                'price' => '200',
                'image' => 'cafe_esp_500gr.jpg',
            ],
            [
                'name' => 'Variedad Marsellesa',
                'description' => 'Café gourmet para cafeteras o clientes exigentes.',
                'contents' => '5',
                'introduction' => 'Molido',
                'origin' => 'Jaltenango Chiapas | 1300 msnm',
                'roasting' => 'Medio',
                'category_id' => '1',
                'measurement_unit_id' => '1',
                'price' => '1800',
                'image' => 'cafe_esp_5kg.jpg',
            ],
            [
                'name' => 'Variedad Marsellesa',
                'description' => 'Café gourmet para cafeteras o clientes exigentes.',
                'contents' => '500',
                'introduction' => 'Grano',
                'origin' => 'Jaltenango Chiapas | 1300 msnm',
                'roasting' => 'Medio',
                'category_id' => '2',
                'measurement_unit_id' => '2',
                'price' => '200',
                'image' => 'cafe_esp_500gr.jpg',
            ],
            [
                'name' => 'Variedad Marsellesa',
                'description' => 'Café gourmet para cafeteras o clientes exigentes.',
                'contents' => '5',
                'introduction' => 'Grano',
                'origin' => 'Jaltenango Chiapas | 1300 msnm',
                'roasting' => 'Medio',
                'category_id' => '2',
                'measurement_unit_id' => '1',
                'price' => '1800',
                'image' => 'cafe_esp_5kg.jpg',
            ],
            [
                'name' => null,
                'description' => 'Ideal para cafeteras o restaurantes.',
                'contents' => '5',
                'introduction' => 'Molido',
                'origin' => 'Jaltenango Chiapas | 1200 msnm',
                'roasting' => 'Medio',
                'category_id' => '4',
                'measurement_unit_id' => '1',
                'price' => '1350',
                'image' => 'cafe_amer_4,5kg.jpg',
            ],
            [
                'name' => null,
                'description' => 'Ideal para cafeteras o restaurantes.',
                'contents' => '4.5',
                'introduction' => 'Grano',
                'origin' => 'Jaltenango Chiapas | 1200 msnm',
                'roasting' => 'Medio',
                'category_id' => '5',
                'measurement_unit_id' => '1',
                'price' => '1350',
                'image' => 'cafe_amer_4,5kg.jpg',
            ],
            // [
            //     'name' => null,
            //     'description' => 'Ideal para cafeteras o restaurantes.',
            //     'contents' => '5',
            //     'introduction' => 'Molido o Grano',
            //     'origin' => 'Jaltenango Chiapas | 1200 msnm',
            //     'roasting' => 'Medio',
            //     'category_id' => '3',
            //     'measurement_unit_id' => '1',
            //     'price' => '1400',
            //     'image' => 'cafe_amer_5kg.jpg',
            // ],
            // [
            //     'name' => null,
            //     'description' => 'Ideal para cafeteras o restaurantes.',
            //     'contents' => '7.5',
            //     'introduction' => 'Molido o Grano',
            //     'origin' => 'Jaltenango Chiapas | 1200 msnm',
            //     'roasting' => 'Medio',
            //     'category_id' => '3',
            //     'measurement_unit_id' => '1',
            //     'price' => '1530',
            //     'image' => 'cafe_amer_7,5kg.jpg',
            // ],
            [
                'name' => 'Variedad Marsellesa',
                'description' => 'Ideal para tostadores pequeños o baristas.',
                'contents' => '7.5',
                'introduction' => 'Verde',
                'origin' => 'Jaltenango Chiapas | 1300 msnm',
                'roasting' => 'Sin Tostar',
                'category_id' => '3',
                'measurement_unit_id' => '1',
                'price' => '1650',
                'image' => 'cafe_verde_esp_7,5kg.jpg',
            ],
            [
                'name' => 'Variedad Marsellesa',
                'description' => 'Ideal para tostadores pequeños o baristas.',
                'contents' => '60',
                'introduction' => 'Verde',
                'origin' => 'Jaltenango Chiapas | 1300 msnm',
                'roasting' => 'Sin Tostar',
                'category_id' => '3',
                'measurement_unit_id' => '1',
                'price' => '12600',
                'image' => 'cafe_verde_esp_60kg.jpg',
            ],
            [
                'name' => null,
                'description' => 'Ideal para tostadores pequeños o baristas.',
                'contents' => '7.5',
                'introduction' => 'Verde',
                'origin' => 'Jaltenango Chiapas | 1200 msnm',
                'roasting' => 'Sin Tostar',
                'category_id' => '6',
                'measurement_unit_id' => '1',
                'price' => '1500',
                'image' => 'cafe_verde_esp_7,5kg.jpg',
            ],
            [
                'name' => null,
                'description' => 'Ideal para tostadores pequeños o baristas.',
                'contents' => '60',
                'introduction' => 'Verde',
                'origin' => 'Jaltenango Chiapas | 1200 msnm',
                'roasting' => 'Sin Tostar',
                'category_id' => '6',
                'measurement_unit_id' => '1',
                'price' => '11400',
                'image' => 'cafe_verde_ame_60kg.jpg',
            ],
        ];

        foreach ($products as $item) {
            $product = Product::create([
                'name'          => $item['name'],
                'description'   => $item['description'],
                'contents'      => $item['contents'],
                'introduction'  => $item['introduction'],
                'origin'        => $item['origin'],
                'roasting'      => $item['roasting'],
                // 'quantity'      => $item->quantity,
                // 'code'          => $item->code,
                'status_id'     => 4,
                // 'subcategory_id' => $item->subcategory_id,
                'category_id'   => $item['category_id'],
                // 'iva'           => $item->iva,
                'measurement_unit_id' => $item['measurement_unit_id'],
            ]);

            ProductPrice::create([
                'price'         => $item['price'],
                'product_id'    => $product->id,
                'status_id'     => 6,
            ]);

            ProductImage::create([
                'path'          => $item['image'],
                'product_id'    => $product->id
            ]);

            // Inventory::create([
            //     'quantity'      => 100,
            //     'product_id'    => $product->id,
            //     // 'clothing_sizes_product_id' => $size_id->id,
            //     'inventory_type_id' => 1,
            // ]);
        }
    }
}
