<?php

namespace Database\Seeders;

use App\Models\Status;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class StatusTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        mb_internal_encoding('UTF-8');
        Status::create(['order' => 1, 'status_type_id' => 1, 'name' => mb_convert_case('Activo', MB_CASE_TITLE)]);//1
        Status::create(['order' => 2, 'status_type_id' => 1, 'name' => mb_convert_case('Inactivo', MB_CASE_TITLE)]);//2
        Status::create(['order' => 3, 'status_type_id' => 1, 'name' => mb_convert_case('Eliminado', MB_CASE_TITLE)]);//3
        Status::create(['order' => 1, 'status_type_id' => 2, 'name' => mb_convert_case('Activo', MB_CASE_TITLE)]);//4
        Status::create(['order' => 2, 'status_type_id' => 2, 'name' => mb_convert_case('Inactivo', MB_CASE_TITLE)]);//5
        Status::create(['order' => 1, 'status_type_id' => 3, 'name' => mb_convert_case('Activo', MB_CASE_TITLE)]);//6
        Status::create(['order' => 2, 'status_type_id' => 3, 'name' => mb_convert_case('Inactivo', MB_CASE_TITLE)]);//7
        Status::create(['order' => 1, 'status_type_id' => 4, 'name' => mb_convert_case('Activo', MB_CASE_TITLE)]);//8
        Status::create(['order' => 2, 'status_type_id' => 4, 'name' => mb_convert_case('Inactivo', MB_CASE_TITLE)]);//9

        Status::create(['order' => 1, 'status_type_id' => 5, 'name' => mb_convert_case('Pedido Pagado', MB_CASE_TITLE)]);//10
        Status::create(['order' => 3, 'status_type_id' => 5, 'name' => mb_convert_case('Orden Rechazada', MB_CASE_TITLE)]);//11
        Status::create(['order' => 4, 'status_type_id' => 5, 'name' => mb_convert_case('Orden Generada', MB_CASE_TITLE)]);//12
        Status::create(['order' => 3, 'status_type_id' => 5, 'name' => mb_convert_case('Comprobando Pago', MB_CASE_TITLE)]);//13
        Status::create(['order' => 4, 'status_type_id' => 5, 'name' => mb_convert_case('Error de Pago', MB_CASE_TITLE)]);//14
        Status::create(['order' => 5, 'status_type_id' => 5, 'name' => mb_convert_case('Pedido en Proceso', MB_CASE_TITLE)]);//15
        Status::create(['order' => 6, 'status_type_id' => 5, 'name' => mb_convert_case('Pedido Listo', MB_CASE_TITLE)]);//16
        Status::create(['order' => 7, 'status_type_id' => 5, 'name' => mb_convert_case('Pedido Enviado', MB_CASE_TITLE)]);//17
        Status::create(['order' => 8, 'status_type_id' => 5, 'name' => mb_convert_case('Pedido Finalizado', MB_CASE_TITLE)]);//18
        Status::create(['order' => 9, 'status_type_id' => 5, 'name' => mb_convert_case('Carrito de Compras', MB_CASE_TITLE)]);//19

        Status::create(['order' => 1, 'status_type_id' => 6, 'name' => mb_convert_case('Activo', MB_CASE_TITLE)]);//20
        Status::create(['order' => 2, 'status_type_id' => 6, 'name' => mb_convert_case('Inactivo', MB_CASE_TITLE)]);//21

        Status::create(['order' => 1, 'status_type_id' => 7, 'name' => mb_convert_case('Activo', MB_CASE_TITLE)]);//22
        Status::create(['order' => 2, 'status_type_id' => 7, 'name' => mb_convert_case('Inactivo', MB_CASE_TITLE)]);//23

        Status::create(['order' => 2, 'status_type_id' => 5, 'name' => mb_convert_case('Orden Aceptada', MB_CASE_TITLE)]);//24
    }
}
