@extends('layouts.landing-page')
@section('content')
    <div class="mx-5 my-5 lg:mx-36 lg:my-20">

        <section class="grid my-5 md:grid-cols-2">
            <div class="flex items-center justify-center ">
                <img src="{{ asset('storage/productos/cafe_org_500.jpg') }}" alt="imagen prooducto">
            </div>
            <div class="flex flex-col ">
                <h3 class="text-3xl font-bold ">CAFÉ ORGÁNICO DE ESPECIALIDAD</h3>
                <h5 class="text-xl font-medium ">Heading 5</h5>
                <h4 class="text-2xl font-bold ">Selecciona tamaño</h4>
                <div class="flex  gap-3 w-[40%]">
                    <div class="p-1 border-2 border-principal hover:cursor-pointer hover:bg-principal hover:text-white">
                        250 gr.
                    </div>
                    <div class="p-1 border-2 border-principal hover:cursor-pointer hover:bg-principal hover:text-white">
                        500 gr.
                    </div>
                </div>
                <div class="inline-flex items-end mt-5">
                    <img src="{{ asset('storage/productos/icono_envio.png') }}" alt="">
                    <p class="ml-1 text-xs font-normal ">*EL ENVÍO SE CALCULA AL MOMENTO DE PAGAR</p>
                </div>

                <div class="flex gap-4 ">
                    <form class="max-w-xs mx-auto">
                        <label for="bags-input" class="block mb-2 text-sm font-medium text-gray-900 ">Elige la
                            cantidad:</label>
                        <div class="relative flex items-center max-w-[11rem]">
                            <button type="button" id="decrement-button" data-input-counter-decrement="bags-input"
                                class="p-3 bg-gray-100 border border-gray-300 hover:bg-gray-200 rounded-s-lg h-11 focus:ring-gray-100 focus:ring-2 focus:outline-none">
                                <svg class="w-3 h-3 text-gray-900 " aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 18 2">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="M1 1h16" />
                                </svg>
                            </button>
                            <input type="text" id="bags-input" data-input-counter data-input-counter-min="1"
                                data-input-counter-max="5" aria-describedby="helper-text-explanation"
                                class="block w-full pb-6 text-sm font-medium text-center text-gray-900 border-gray-300 bg-gray-50 border-x-0 h-11 focus:ring-blue-500 focus:border-blue-500 "
                                placeholder="" value="3" required />
                            <div
                                class="absolute flex items-center space-x-1 text-xs text-gray-400 -translate-x-1/2 bottom-1 start-1/2 rtl:translate-x-1/2 rtl:space-x-reverse">

                                <span>Bolsas</span>
                            </div>
                            <button type="button" id="increment-button" data-input-counter-increment="bags-input"
                                class="p-3 bg-gray-100 border border-gray-300 hover:bg-gray-200 rounded-e-lg h-11 focus:ring-gray-100 focus:ring-2 focus:outline-none">
                                <svg class="w-3 h-3 text-gray-900 " aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 18 18">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="M9 1v16M1 9h16" />
                                </svg>
                            </button>
                        </div>

                    </form>

                    <button
                        class="w-full px-4 py-2 mt-3 text-lg font-semibold text-white rounded-2xl bg-principal hover:bg-principalhover">
                        AÑADIR AL CARRITO
                    </button>
                </div>

                <div class="w-full mt-4 border-t-4 border-b-4">
                    <h5 class="text-xl font-normal text-principal">FICHA TÉCNICA</h5>
                    <div class="flex flex-col ">
                        <div class="flex items-center mr-6">
                            <img src="{{ asset('storage/productos/icono_lugar.png') }}" alt="Altura"
                                class="w-3 h-4 mr-2 ">
                            <span class="text-base ">Origen | Jaltenango, Chiapas</span>
                        </div>
                        <div class="flex items-center mr-6">

                            <img src="{{ asset('storage/productos/icono_granos.png') }}" alt="Variedad"
                                class="w-4 h-4 mr-2">
                            <span class="text-base ">Tueste | Oscuro</span>
                        </div>
                        <div class="flex items-center">
                            <img src="{{ asset('storage/productos/icono_hojas.png') }}" alt="Proceso" class="w-4 h-4 mr-2">
                            <span class="text-base ">Tipo | Arábico</span>
                        </div>
                        <div class="flex items-center">
                            <img src="{{ asset('storage/productos/icono_reglas.png') }}" alt="Proceso"
                                class="w-3 h-4 mr-2">
                            <span class="text-base ">Origen | 1,350 msnm.</span>
                        </div>
                    </div>
                </div>

                <h5 class="text-xl font-normal text-principal">DESCRIPCIÓN</h5>
                <p class="font-semibold">Usamos variedad de mejor calidad con un proceso que resalta el sabor, recomendado
                    también para preparar un café muy fuerte tipo espresso. </p>

            </div>
        </section>
        <section>
            {{-- productos --}}
            <h4 class="mx-5 text-2xl font-bold uppercase ">También te puede interesar</h4>
            <section class="grid grid-cols-1 gap-3 lg:gap-8 md:grid-cols-3 ">
                <a href="{{ route('product') }}" class="flex flex-col items-center justify-center">
                    <img class="h-[60%] lg:h-auto" src="{{ asset('storage/productos/cafe_org_500.jpg') }}" alt="producto">
                    <h4 class="text-2xl font-semibold text-center lg:text-start">CAFÉ ORGÁNICO DE ESPECIALIDAD 500 gr.</h4>
                </a>
                <div class="flex flex-col items-center justify-center">
                    <img class="h-[60%] lg:h-auto" src="{{ asset('storage/productos/cafe_org_amer_7,5.jpg') }}"
                        alt="producto">
                    <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ORGÁNICO AMERICANO 7.5 kg.</h4>
                </div>
                <a class="flex flex-col items-center justify-center">
                    <img class="h-[60%] lg:h-auto" src="{{ asset('storage/productos/cafe_esp_amer_7,5.jpg') }}"
                        alt="producto">
                    <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ESPECIAL ORGÁNICO 7.5 kg.</h4>
                </a>
                <a class="flex flex-col items-center justify-center">
                    <img class="h-[60%] lg:h-auto" src="{{ asset('storage/productos/cafe_org_500.jpg') }}"
                        alt="producto">
                    <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ORGÁNICO DE ESPECIALIDAD 500 gr.
                    </h4>
                </a>
                <a class="flex flex-col items-center justify-center">
                    <img class="h-[60%] lg:h-auto" src="{{ asset('storage/productos/cafe_org_amer_7,5.jpg') }}"
                        alt="producto">
                    <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ORGÁNICO AMERICANO 7.5 kg.</h4>
                </a>
                <a class="flex flex-col items-center justify-center">
                    <img class="h-[60%] lg:h-auto" src="{{ asset('storage/productos/cafe_esp_amer_7,5.jpg') }}"
                        alt="producto">
                    <h4 class="text-2xl font-semibold text-center lg:text-start ">CAFÉ ESPECIAL ORGÁNICO 7.5 kg.</h4>
                </a>
            </section>
            {{-- productos --}}

        </section>
    </div>
@endsection
