<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="icon" href="{{ asset('storage/favicons/icons/favicon.ico') }}" type="image/x-icon">

    <title>Café Finca Monteverde | De la finca a tu taza</title>

    <meta name="description" content="Finca Monte Verde legado familiar representado por 3 generaciones dedicadas al café.">
    <meta name="keywords" content="café, finca, agricultura, sostenibilidad, comercio, justo, calidad, elegancia, ">
    <meta name="author" content="Chandomi Consulting">

    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="Café Finca Monteverde | De la finca a tu taza">
    <meta property="og:description" content="Nuestro café se distingue desde el origen, ubicados en Jaltenango la Paz Chiapas.">
    <meta property="og:image" content="{{ asset('storage/favicons/icons/favicon.ico') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:site_name" content="Café Finca Monteverde">
    <meta property="og:locale" content="es_MX">
    <meta property="og:image:alt" content="Logo de Café Finca Monteverde">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Café Finca Monteverde | De la finca a tu taza">
    <meta name="twitter:description" content="Nuestro café se distingue desde el origen, ubicados en Jaltenango la Paz Chiapas.">
    <meta name="twitter:image" content="{{ asset('storage/favicons/icons/favicon.ico') }}">
    <meta name="twitter:site" content="@">
    <meta name="twitter:creator" content="@">

    <meta name="robots" content="index, follow">
    <meta name="googlebot" content="index, follow">
    <meta name="theme-color" content="#003366">

    @include('partials.metas')

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Aleo:ital,wght@0,100..900;1,100..900&family=Sarabun:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800&display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet" />

    {{-- test --}}
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    {{-- produccion --}}
    {{-- @php
        $cwd = getcwd();
        $cssName = basename(glob($cwd . '/build/assets/*.css')[0], '.css');
        $jsName = basename(glob($cwd . '/build/assets/*.js')[0], '.js');
        $css = asset('build/assets/' . $cssName . '.css');
        $js = asset('build/assets/' . $jsName . '.js');
    @endphp
    <link rel="stylesheet" href="{{ $css }}" id="css">
    <script src="{{ $js }}" id="js"></script> --}}
    {{-- Agrega aquí tus estilos comunes --}}
    @livewireStyles
    @stack('css')
    @stack('js')
</head>

<body class="flex flex-col min-h-screen antialiased">
    @include('partials.alerts')
    @include('partials.nav')

    <main class="flex-1 pb-1">
        @yield('content')
    </main>

    {{--  @include('partials.footer')  --}}
    @livewire('dashboard.footer')

    @livewireScripts
</body>

</html>
