<div>
    <a href="{{ route('comments.index',$product) }}">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-principal rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Regresar</p>
        </button>
    </a>
    <div class="container max-w-xl min-h-screen px-4 py-8 mx-auto">
        <div class="mx-auto bg-white rounded-lg shadow-xl overflow-scrollflow-hidden dark:bg-gray-700">
            <div class="px-8 py-6">
                <h2 class="mb-4 text-2xl font-bold text-gray-800 dark:text-white">Agregar Comentarío</h2>
                <form wire:submit.prevent="save" class="space-y-4">
                    <div class="mb-4">
                        <label for="client" class="block mb-2 font-bold text-gray-700 dark:text-white">Nombre del Cliente</label>
                        <input type="text" id="client" name="client" wire:model="client"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'client'])
                    </div>
                    <div class="mb-4">
                        <label for="description"
                            class="block mb-2 font-bold text-gray-700 dark:text-white">Descripción</label>
                        <input type="text" id="description" name="description" wire:model="description"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'description'])
                    </div>
                    {{-- <div class="mb-4">
                        <label for="code" class="block mb-2 font-bold text-gray-700 dark:text-white">Clave</label>
                        <input type="text" id="code" name="code" wire:model="code"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'code'])
                    </div> --}}
                    <div class="mb-4">
                        <label for="rating" class="block mb-2 font-bold text-gray-700 dark:text-white">Calificación</label>
                        <div class="relative">
                            <select wire:model.lazy="rating"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="rating">
                                @for ($i = 1; $i <= 5; $i++)
                                    <option value="{{ $i }}">{{ $i }}</option>
                                @endfor
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'rating'])
                    </div>
                    {{-- <div class="mb-4">
                        <label for="measurement_unit_id"
                            class="block mb-2 font-bold text-gray-700 dark:text-white">Unidad
                            de Medida</label>
                        <div class="relative">
                            <select wire:model.lazy="measurement_unit_id"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="measurement_unit_id">
                                @foreach ($measurement_units as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @endforeach
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'measurement_unit_id'])
                    </div> --}}
                    {{-- <div class="mb-4">
                        <label for="category_id"
                            class="block mb-2 font-bold text-gray-700 dark:text-white">Categorías</label>
                        <div class="relative">
                            <select wire:model.lazy="category_id" wire:change="selectCategory()"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="category_id">
                                @foreach ($categories as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @endforeach
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'category_id'])
                    </div> --}}
                    {{-- <div class="mb-4">
                        <label for="subcategory_id"
                            class="block mb-2 font-bold text-gray-700 dark:text-white">Subcategorías</label>
                        <div class="relative">
                            <select wire:model.lazy="subcategory_id"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="subcategory_id">
                                @foreach ($subcategories as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @endforeach
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'subcategory_id'])
                    </div> --}}
                    {{-- <div class="mb-4">
                        <label for="quantity"
                            class="block mb-2 font-bold text-gray-700 dark:text-white">Cantidad</label>
                        <input type="number" id="quantity" name="quantity" wire:model="quantity"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'quantity'])
                    </div> --}}
                    {{-- <div class="mb-4">
                        <label for="price" class="block mb-2 font-bold text-gray-700 dark:text-white">Precio</label>
                        <input type="number" id="price" name="price" wire:model="price" step="any"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'price'])
                    </div> --}}
                    {{-- <div class="flex flex-col mb-4">
                        @foreach ($clothing_sizes_data as $row)
                        <label class="dark:text-white" for="clothing_sizes{{ $row->id }}">
                            <input type="checkbox" wire:model="clothing_sizes" value="{{ $row->id }}"
                                id="clothing_sizes{{ $row->id }}" class="mr-2"> {{ $row->name }}
                        </label>
                        @endforeach
                        @include('partials.input-error', ['input' => 'clothing_sizes'])
                    </div> --}}
                    <div class="flex items-center justify-between">
                        <button type="submit"
                            class="px-4 py-2 font-bold text-white rounded-sm bg-principal hover:bg-principal focus:outline-hidden focus:shadow-outline">
                            Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
