<div class="min-h-screen p-6 bg-gray-100">
    <!-- Botón de regresar -->
    <a href="{{ route('configuration.index') }}">
        <button type="button"
            class="flex items-center justify-center px-5 py-2 mt-10 ml-5 text-sm font-semibold text-gray-700 transition duration-200 bg-white border border-gray-300 rounded-lg gap-x-2 hover:bg-gray-100 hover:text-gray-900 focus:ring-3 focus:ring-blue-200 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-200 dark:hover:bg-gray-700">
            <svg class="w-5 h-5 rtl:rotate-180" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                stroke-width="1.5" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 15.75L3 12m0 0l3.75-3.75M3 12h18" />
            </svg>
            <span>Regresar</span>
        </button>
    </a>

    <!-- Título -->
    <h1 class="mt-10 mb-4 text-3xl font-extrabold text-center text-gray-800 dark:text-gray-200">
        Actualizar contactos
    </h1>

    <!-- Formulario -->
    <form wire:submit.prevent="save" method="POST" class="mx-auto max-w-7xl">
        <div class="grid grid-cols-1 gap-6 md:grid-cols-3">
            @foreach ($dataType as $type)
                
                <div class="flex flex-col items-center justify-center p-6 bg-white shadow-lg rounded-xl dark:bg-gray-800">
                    <img class="w-12 h-12 mb-4" src="{{ asset('storage/icons//' . $type->image) }}" alt="">
                    <label for="data.{{ $type->id }}"
                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-200">{{ $type->name }}</label>

                    @if ($type->contact_type_id != 6)
                        <input type="text" id="data.{{ $type->id }}" wire:model="data.{{ $type->id }}"
                            class="w-full p-2.5 text-sm text-gray-900 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500 bg-gray-50 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    @else
                        <textarea id="data.{{ $type->id }}" wire:model="data.{{ $type->id }}"
                            class="w-full p-2.5 text-sm text-gray-900 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500 bg-gray-50 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"></textarea>
                    @endif

                    @include('partials.message', ['input' => 'data.' . $type->id])
                </div>
            @endforeach
        </div>
        
       
        
        <!-- Botón de guardar -->
        <div class="flex justify-center mt-8">
            <button type="submit"
                class="px-6 py-3 text-lg font-bold text-white transition duration-200 rounded-lg shadow-md bg-principal hover:bg-principalhover focus:outline-hidden focus:ring-3 focus:ring-blue-300">
                Guardar
            </button>
        </div>
    </form>
</div>
