<div class="mx-auto md:p-8 ">
    <!-- Header Section for Store Actions -->
    <div class="flex flex-col items-center justify-between p-4 space-y-3 md:flex-row md:space-y-0 md:space-x-4">
        <div
            class="flex flex-col items-stretch justify-end shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
            <a href="{{ route('configuration.create') }}"
                class="flex items-center justify-center px-6 py-3 text-sm font-medium text-white rounded-lg bg-principal hover:bg-principalhover focus:ring-4 focus:ring-blue-300 ">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                    <path
                        d="M21.731 2.269a2.625 2.625 0 0 0-3.712 0l-1.157 1.157 3.712 3.712 1.157-1.157a2.625 2.625 0 0 0 0-3.712ZM19.513 8.199l-3.712-3.712-8.4 8.4a5.25 5.25 0 0 0-1.32 2.214l-.8 2.685a.75.75 0 0 0 .933.933l2.685-.8a5.25 5.25 0 0 0 2.214-1.32l8.4-8.4Z" />
                    <path
                        d="M5.25 5.25a3 3 0 0 0-3 3v10.5a3 3 0 0 0 3 3h10.5a3 3 0 0 0 3-3V13.5a.75.75 0 0 0-1.5 0v5.25a1.5 1.5 0 0 1-1.5 1.5H5.25a1.5 1.5 0 0 1-1.5-1.5V8.25a1.5 1.5 0 0 1 1.5-1.5h5.25a.75.75 0 0 0 0-1.5H5.25Z" />
                </svg>
                Editar elementos
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 gap-6 xl:grid-cols-2 ">
        @foreach ($details as $detail)
        {{-- {{$detail}} --}}
        @if ($detail->id == 10)
        <div class="flex flex-col h-full py-5 border rounded-lg md:col-span-2 md:flex-row border-principal">
            <div class="flex flex-col items-center md:w-[30%]">

                <img class="mt-6 size-16 md:mt-0"
                    src="{{asset('storage/icons//'.$detail->contactDataType->image)}}" alt="">
                <span>{{ $detail->contactDataType->name }}</span>
                {{-- toggle --}}
                <div class="flex items-center justify-center">
                    <div class="relative w-16 h-9">
                        <!-- Fondo del toggle -->

                        <div class="absolute inset-0 rounded-full transition-colors duration-300 ease-in-out
                                                   {{ $detail->status_id == 20 ? 'bg-green-500' : 'bg-red-500' }}">
                        </div>

                        <!-- Botón del toggle -->
                        <button wire:click="changeStatus({{ $detail->id }}, {{ $detail->status_id == 20 ? 21 : 20 }})"
                            aria-label="Cambiar estado"
                            class="absolute top-1/2 left-0 w-8 h-8 bg-white rounded-full shadow-md border border-gray-300 transition-transform duration-300 ease-in-out transform
                                                   {{ $detail->status_id == 20 ? 'translate-x-full -translate-y-1/2' : '-translate-y-1/2' }}">
                        </button>
                    </div>
                </div>
                {{-- toggle --}}
            </div>
            <div class="flex md:w-[70%] justify-center items-center">
                <div class=" w-[80%]">
                    <label for="message"
                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Link</label>
                    
                    <textarea id="message" rows="10"
                        class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 "
                        placeholder="Link">{{ $detail->resource }}</textarea>
                </div>
            </div>
        </div>
            
        @else
        <div class="flex flex-col h-full py-5 border rounded-lg md:flex-row border-principal">
            <div class="flex flex-col items-center md:w-[30%]">

                <img class="mt-6 size-16 md:mt-0"
                    src="{{asset('storage/icons//'.$detail->contactDataType->image)}}" alt="">
                <span>{{ $detail->contactDataType->name }}</span>
                {{-- toggle --}}
                {{--  <div class="flex items-center justify-center">
                    <div class="relative w-16 h-9">
                        <!-- Fondo del toggle -->

                        <div class="absolute inset-0 rounded-full transition-colors duration-300 ease-in-out
                                                   {{ $detail->status_id == 20 ? 'bg-green-500' : 'bg-red-500' }}">
                        </div>

                        <!-- Botón del toggle -->
                        <button wire:click="changeStatus({{ $detail->id }}, {{ $detail->status_id == 20 ? 21 : 20 }})"
                            aria-label="Cambiar estado"
                            class="absolute top-1/2 left-0 w-8 h-8 bg-white rounded-full shadow-md border border-gray-300 transition-transform duration-300 ease-in-out transform
                                                   {{ $detail->status_id == 20 ? 'translate-x-full -translate-y-1/2' : '-translate-y-1/2' }}">
                        </button>
                    </div>
                </div>  --}}
                {{-- toggle --}}
            </div>
            <div class="flex md:w-[70%] justify-center items-center">
                <div class=" w-[80%]">
                    <label for="message"
                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Valor</label>

                    <div
                        class="w-full break-words p-2.5 mb-6 text-sm text-gray-900 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500 bg-gray-50">
                        {{ $detail->resource }}</div>
                </div>
            </div>
        </div>
        @endif
        @endforeach
    </div>

  
</div>