@push('css')
    <style>
        html {
            scroll-behavior: smooth;
        }
    </style>
@endpush
<div>

    <a href="{{ route('products.index') }}">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-principal  rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Regresar</p>
        </button>
    </a>
    @if ($type == 0)
        <a href="#agregar">
            <button wire:click="create"
                class="flex items-center justify-center px-4 py-4 mt-5 text-sm font-medium text-white rounded-lg bg-principal bg-primary-700 hover:bg-principalhover focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-hidden dark:focus:ring-primary-800">
                <svg class="h-3.5 w-3.5 mr-2" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"
                    aria-hidden="true">
                    <path clip-rule="evenodd" fill-rule="evenodd"
                        d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" />
                </svg>

                @if ($images->isEmpty())
                    Agregar portada
                @else
                    Insertar nueva imagen
                @endif

            </button>
        </a>
        @include('partials.input-error', ['input' => 'max'])

        <h3 class="mt-3 text-2xl font-bold xs:text-3xl dark:text-white">Galería de Imagenes</h3>
        <div class="flex flex-row w-full overflow-x-auto overflow-y-hidden gap-3 h-[30rem] ">
            @if ($images->isEmpty())
                <img class="object-contain w-full h-full" src="{{ asset('storage/muestra/insertarimg.jpeg') }}"
                    alt=" ">
            @endif
            @foreach ($images as $row)
                <div class="flex-none h-[70%] mt-3 relative basis-3/4 sm:basis-1/2 md:basis-1/3 lg:basis-1/4">
                    <button id="dropdownMenuIconButton{{$row->id}}" data-dropdown-toggle="dropdownDots{{$row->id}}"
                        class="absolute top-0 right-0 inline-flex items-center p-2 text-sm font-medium text-center text-white rounded-lg bg-principal hover:bg-principalhover focus:ring-4 focus:outline-none focus:ring-gray-50 "
                        type="button">
                        <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 4 15">
                            <path
                                d="M3.5 1.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm0 6.041a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm0 5.959a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z" />
                        </svg>
                    </button>
                    
                    <!-- Dropdown menu -->
                    <div id="dropdownDots{{$row->id}}"
                        class="z-10 hidden bg-white divide-y divide-gray-100 rounded-lg shadow-sm w-44 dark:bg-gray-700 dark:divide-gray-600">
                        <ul class="py-2 text-sm text-gray-700 dark:text-gray-200" aria-labelledby="dropdownMenuIconButton">
                            <li>
                                <a wire:click="edit({{ $row->id }})"
                                    class="block px-4 py-2 hover:cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">{{ $loop->first ? 'Editar portada' : 'Editar imagen' }}</a>
                            </li>
                            <li>
                                <a wire:click="slider({{ $row->id }})"
                                    class="block px-4 py-2 hover:cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">{{ $row->slider == 1 ? 'Quitar del' : 'Agregar a' }} slider</a>
                            </li>
                        </ul>
                        <div class="py-2">
                            <a wire:click="delete({{ $row->id }})"
                                class="block px-4 py-2 text-sm bg-red-500 hover:cursor-pointer hover:bg-red-700 text-red-50 ">Eliminar</a>
                        </div>
                    </div>
                    
                    <img class="object-cover w-full h-full" src="{{ asset('storage/images/gallery/' . $row->path) }}"
                        alt="{{ $row->path }}">
                 
                </div>
            @endforeach
            <span id="agregar"></span>
        </div>
    @else
        <h3>{{ $type == 1 ? 'Agregar' : 'Editar' }} Imagen</h3>
        <form wire:submit.prevent="save">
            <div class="flex flex-col items-center justify-center px-6 py-4 mt-5 bg-white dark:bg-gray-700 md:flex-row">
                <div class="flex flex-col">
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white" for="image">Subir
                        imagen</label>
                    <input accept="image/*"
                        class="block w-full text-sm text-gray-900 bg-white border border-gray-300 rounded-lg cursor-pointer dark:text-gray-400 focus:outline-hidden dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400"
                        aria-describedby="file_input_help" id="image" type="file" wire:model="image">
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-300" id="file_input_help">
                        JPEG, JPG o PNG.
                    </p>
                    @include('partials.input-error', ['input' => 'image'])
                </div>
                <div class="flex flex-col mt-4 md:mt-0 md:ml-6">
                    <p class="text-center text-gray-600 dark:text-white">
                        <bold>Aspect Ratio:</bold>3:4 <br> Ejemplo max: 3000x4000 <br> Ejemplo min: 700x900 <br> <span
                            class="text-red-500">No exceder los
                            2MB</span>
                    </p>
                    @if ($image)
                        <img src="{{ $image->temporaryUrl() }}" alt="Imagen Cargada"
                            class="w-48 h-64 mx-auto mt-4 rounded-lg shadow-md">
                        <button type="submit"
                            class="px-4 py-2 text-xl text-white rounded-lg bg-principal hover:bg-principalhover focus:outline-hidden focus:bg-principal">
                            Guardar nueva imagen
                        </button>
                    @else
                        <img src="https://placehold.co/3000x4000" alt="Placeholder"
                            class="w-48 h-64 mx-auto mt-4 rounded-lg shadow-md">
                    @endif
                </div>
                @if ($type == 2)
                    <div class="flex flex-col mt-4 md:mt-0 md:ml-6">
                        <p class="text-center text-gray-600 dark:text-white">
                            <bold class="font-bold">Imagen actual</bold> <span class="text-red-500">No exceder los
                                2MB</span>
                        </p>
                        <img src="{{ asset('storage/images/gallery/' . $product_image->path) }}" alt="Imagen Cargada"
                            class="w-48 h-64 mx-auto mt-4 rounded-lg shadow-md">
                    </div>
                @endif
            </div>
            <div class="flex justify-end mt-6 ">
                <button type="button" wire:click="cancel"
                    class="px-4 py-2 text-xl text-white bg-red-500 rounded-lg hover:bg-red-700 focus:outline-hidden focus:bg-orange-600">
                    Cancelar
                </button>



            </div>
        </form>
    @endif
    <hr>

</div>

@push('js')
    <script>
        document.getElementById('scrollToTop').addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth' // Desplazamiento suave
            });
        });
    </script>
@endpush
