<section class="mt-5">
    <div
        class="flex flex-row items-center justify-between w-full pb-4 mb-6 border-b border-gray-200 dark:border-gray-700">
        @include('partials.backButton', ['url' => route('products.index')])
    </div>
    <div class="w-full mt-5">
        <div class="overflow-hidden bg-white rounded-lg ">
            <div class="p-5 lg:p-10">
                <h2 class="mb-2 text-2xl font-semibold text-gray-800 dark:text-white">Cantidad de Productos del
                    Inventario</h2>
                {{-- <p class="mb-4 text-gray-600 dark:text-white">Crear nuevo item</p> --}}
                <form wire:submit="save">
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Nombre del
                        Producto: {{ $product->name }}</label>
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Descripción:
                        {{ $product->description }}</label>
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Cantidad:
                        {{ $product->quantity($product->id) }}</label>
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Precio
                        Actual: ${{ $product->price->price }}</label>

                    <div class="flex flex-col w-full gap-5 my-6 md:flex-row lg:gap-10">
                        <div class="w-full md:w-1/2">
                            <label for="inventory_type_id"
                                class="block mb-2 font-medium text-gray-900 dark:text-white">Tipo de Acción</label>
                            <select id="inventory_type_id" wire:model="inventory_type_id"
                                class="bg-gray-50 border border-gray-300 dark:border  text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                @foreach ($inventoryTypes as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @endforeach
                            </select>
                            @include('partials.input-error', ['input' => 'inventory_type_id'])
                        </div>

                        <div class="w-full md:w-1/2">
                            <label for="quantity"
                                class="block mb-2 font-semibold text-gray-700 dark:text-white">Cantidad de
                                Productos</label>
                            <input type="number" id="quantity" name="quantity" min="1" wire:model="quantity"
                                required
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-hidden focus:border-blue-500">
                            @include('partials.input-error', ['input' => 'quantity'])
                        </div>
                    </div>
                    {{-- <div class="mb-4">
                            <label for="size_id"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Talla</label>
                            <select id="size_id" wire:model="size_id" wire:change="inventory()"
                                class="bg-gray-50 border border-gray-300 dark:border  text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                @foreach ($clothing_sizes_data as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @endforeach
                            </select>
                            @include('partials.input-error', ['input' => 'size_id'])
                        </div> --}}

                    <div class="flex items-center justify-between gap-3 mt-10">
                        <button type="submit" id="submitBtn"
                            class="px-4 py-2 font-bold text-white transition-all duration-300 rounded-md bg-principal hover:bg-principalhover focus:outline-hidden focus:shadow-outline">
                            Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
        {{-- <div class="container mx-auto">
            <div class="my-6 bg-white rounded-sm shadow-md">
                <table class="min-w-full bg-white">
                    <thead>
                        <tr>
                            <th class="px-4 py-2 bg-gray-200">Fecha</th>
                            <th class="px-4 py-2 bg-gray-200">Añadidos</th>
                            <th class="px-4 py-2 bg-gray-200">Ventas</th>
                            <th class="px-4 py-2 bg-gray-200">Resta</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="px-4 py-2 border-b">2023-08-01</td>
                            <td class="px-4 py-2 border-b">1000</td>
                            <td class="px-4 py-2 border-b">500</td>
                            <td class="px-4 py-2 border-b">500</td>
                        </tr>
                        <tr>
                            <td class="px-4 py-2 border-b">2023-08-02</td>
                            <td class="px-4 py-2 border-b">1200</td>
                            <td class="px-4 py-2 border-b">600</td>
                            <td class="px-4 py-2 border-b">600</td>
                        </tr>
                        <!-- Añadir más filas según sea necesario -->
                    </tbody>
                </table>
            </div>
        </div> --}}
    </div>
</section>

@push('js')
    <script>
        function deshabilitarBoton(event) {
            event.preventDefault();

            const boton = document.getElementById('submitBtn');

            boton.disabled = true;

            boton.textContent = "Enviando...";

            boton.classList.add('bg-gray-500', 'cursor-not-allowed');
            boton.classList.remove('bg-principal', 'hover:bg-orange-600');
        }
    </script>
@endpush
