<div>
    <div
        class="flex flex-row items-center justify-between w-full pb-4 mb-6 border-b border-gray-200 dark:border-gray-700">
        @include('partials.backButton', ['url' => route('products.index')])
    </div>
    <div class="mx-auto mt-5 bg-white rounded-lg shadow-xl overflow-scrollflow-hidden dark:bg-gray-700">
        <div class="px-8 py-6">
            <h2 class="mb-4 text-2xl font-bold text-gray-800 dark:text-white">Editar Producto</h2>
            <form wire:submit.prevent="save" class="flex flex-col w-full space-y-4">
                <div class="flex flex-col w-full gap-10 md:flex-row">
                    <div class="w-full md:w-1/2">
                        <div class="mb-4">
                            <label for="name" class="block mb-2 font-bold text-principalhover dark:text-white">Nombre
                                del Producto</label>
                            <input type="text" id="name" name="name" wire:model="name"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'name'])
                        </div>
                        <div class="mb-4">
                            <label for="description"
                                class="block mb-2 font-bold text-principalhover dark:text-white">Descripción</label>
                            <input type="text" id="description" name="description" wire:model="description"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'description'])
                        </div>
                        <div class="mb-4">
                            <label for="contents"
                                class="block mb-2 font-bold text-principalhover dark:text-white">Contenido</label>
                            <input type="number" step="any" id="contents" name="contents" wire:model="contents"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'contents'])
                        </div>
                        <div class="mb-4">
                            <label for="introduction"
                                class="block mb-2 font-bold text-principalhover dark:text-white">Presentación</label>
                            <input type="text" id="introduction" name="introduction" wire:model="introduction"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'introduction'])
                        </div>
                        <div class="mb-4">
                            <label for="origin"
                                class="block mb-2 font-bold text-principalhover dark:text-white">Origen</label>
                            <input type="text" id="origin" name="origin" wire:model="origin"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'origin'])
                        </div>
                    </div>

                    <div class="w-full md:w-1/2">
                        <div class="mb-4">
                            <label for="roasting"
                                class="block mb-2 font-bold text-principalhover dark:text-white">Tueste</label>
                            <input type="text" id="roasting" name="roasting" wire:model="roasting"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'roasting'])
                        </div>
                        {{-- <div class="mb-4">
                        <label for="code" class="block mb-2 font-bold text-gray-700 dark:text-white">Clave</label>
                        <input type="text" id="code" name="code" wire:model="code"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'code'])
                    </div> --}}
                        {{-- <div class="mb-4">
                        <label for="iva" class="block mb-2 font-bold text-gray-700 dark:text-white">IVA</label>
                        <div class="relative">
                            <select wire:model.lazy="iva"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="iva">
                                <option value="1">SI</option>
                                <option value="0">NO</option>
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'iva'])
                    </div> --}}
                        <div class="mb-4">
                            <label for="measurement_unit_id"
                                class="block font-bold mt-7 text-principalhover dark:text-white">Unidad de
                                Medida</label>
                            <div class="relative">
                                <select wire:model.lazy="measurement_unit_id"
                                    class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-md appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                    id="measurement_unit_id">
                                    @foreach ($measurement_units as $row)
                                        <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                                <div
                                    class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M5 6l5 5 5-5z" />
                                    </svg>
                                </div>
                            </div>
                            @include('partials.input-error', ['input' => 'measurement_unit_id'])
                        </div>
                        <div class="mb-4">
                            <label for="category_id"
                                class="block font-bold mt-7 text-principalhover dark:text-white">Categorías</label>
                            <div class="relative">
                                <select wire:model.lazy="category_id" {{-- wire:change="selectCategory()" --}}
                                    class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-md appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                    id="category_id">
                                    @foreach ($categories as $row)
                                        <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                                <div
                                    class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M5 6l5 5 5-5z" />
                                    </svg>
                                </div>
                            </div>
                            @include('partials.input-error', ['input' => 'category_id'])
                        </div>
                        {{-- <div class="mb-4">
                        <label for="subcategory_id"
                            class="block mb-2 font-bold text-gray-700 dark:text-white">Subcategorías</label>
                        <div class="relative">
                            <select wire:model.lazy="subcategory_id"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="subcategory_id">
                                @foreach ($subcategories as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @endforeach
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'subcategory_id'])
                    </div> --}}
                        {{-- <div class="mb-4">
                        <label for="quantity"
                            class="block mb-2 font-bold text-gray-700 dark:text-white">Cantidad</label>
                        <input type="number" id="quantity" name="quantity" wire:model="quantity"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'quantity'])
                    </div> --}}
                        <div class="mb-4">
                            <label for="price"
                                class="block mb-2 font-bold text-principalhover dark:text-white">Precio</label>
                            <input type="number" id="price" name="price" wire:model="price" step="any"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-principal focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'price'])
                        </div>
                        {{-- <div class="flex flex-col mb-4">
                        <span class="block mb-2 font-bold text-gray-700 ">Tallas</span>
                        @foreach ($clothing_sizes_data as $row)
                            <label class="dark:text-white" for="clothing_sizes{{ $row->id }}">
                                <input type="checkbox" wire:model="clothing_sizes" value="{{ $row->id }}"
                                    id="clothing_sizes{{ $row->id }}" class="mr-2"> {{ $row->name }}
                            </label>
                        @endforeach
                        @include('partials.input-error', ['input' => 'clothing_sizes'])
                    </div> --}}
                        <div class="mb-4">
                            <label class="block font-bold mt-7 text-principalhover dark:text-white"
                                for="status_id">Estado</label>
                            <div class="relative">
                                <select wire:model.lazy="status_id"
                                    class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-md appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                    id="status_id">
                                    @foreach ($status as $row)
                                        <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                                <div
                                    class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M5 6l5 5 5-5z" />
                                    </svg>
                                </div>
                            </div>
                            @include('partials.input-error', ['input' => 'status_id'])
                        </div>
                    </div>
                </div>

                <div
                    class="flex flex-col items-center justify-center px-6 py-4 mt-5 bg-white dark:bg-gray-700 md:flex-row">
                    <div class="flex flex-col">
                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"
                            for="image">Subir
                            imagen</label>
                        <input accept="image/*"
                            class="block w-full text-sm text-gray-900 bg-white border border-gray-300 rounded-lg cursor-pointer dark:text-gray-400 focus:outline-hidden dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400"
                            aria-describedby="file_input_help" id="image" type="file" wire:model="image">
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300" id="file_input_help">
                            JPEG, JPG o PNG.
                        </p>
                        @include('partials.input-error', ['input' => 'image'])
                    </div>
                    <div class="flex flex-col mt-4 md:mt-0 md:ml-6">
                        @if ($image)
                            <img src="{{ $image->temporaryUrl() }}" alt="Imagen Cargada"
                                class="w-48 h-64 mx-auto mt-4 rounded-lg shadow-md">
                            {{-- <button type="submit"
                                    class="px-4 py-2 text-xl text-white rounded-lg bg-principal hover:bg-principalhover focus:outline-hidden focus:bg-principal">
                                    Guardar nueva imagen
                                </button> --}}
                        @else
                            <img src="https://placehold.co/3000x4000" alt="Placeholder"
                                class="w-48 h-64 mx-auto mt-4 rounded-lg shadow-md">
                        @endif
                        <p class="mt-4 text-center text-gray-600 dark:text-white">
                            <bold>Aspect Ratio:</bold>3:4 <br> Ejemplo max: 3000x4000 <br> Ejemplo min: 700x900 <br>
                            <span class="text-red-500">No exceder los
                                2MB</span>
                        </p>
                    </div>
                    {{-- @if ($type == 2)
                            <div class="flex flex-col mt-4 md:mt-0 md:ml-6">
                                <p class="text-center text-gray-600 dark:text-white">
                                    <bold class="font-bold">Imagen actual</bold> <span class="text-red-500">No exceder
                                        los
                                        2MB</span>
                                </p>
                                <img src="{{ asset('storage/images/gallery/' . $product_image->path) }}"
                                    alt="Imagen Cargada" class="w-48 h-64 mx-auto mt-4 rounded-lg shadow-md">
                            </div>
                        @endif --}}
                </div>

                <div class="flex items-center justify-between">
                    <button type="submit"
                        class="px-4 py-2 font-bold text-white transition-all duration-300 rounded-md bg-principal hover:bg-principalhover focus:outline-hidden focus:shadow-outline">
                        Guardar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
