<section class="antialiased md:p-3 bg-gray-50 rounded-xl dark:bg-gray-900 sm:p-5">
    <div class="relative mt-5 overflow-hidden bg-white rounded-lg shadow-md dark:bg-gray-800">
        <h3 class="mx-5 mt-3 text-3xl font-bold dark:text-white">Productos</h3>
        <div class="flex flex-col items-center justify-between p-4 space-y-3 md:flex-row md:space-y-0 md:space-x-4">
            <div class="w-full md:w-1/3">
                {{-- BARRA DE BUSQUEDA --}}
                <div class="flex items-center">
                    <label for="simple-search" class="sr-only">Search</label>
                    <div class="relative w-full">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                                viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <input type="text" id="simple-search" wire:keydown="searchElement()" wire:model="search"
                            class="block w-full p-2 pl-10 text-sm text-gray-900 border rounded-lg border-principal bg-gray-50 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="Buscar productos" required="">
                    </div>
                </div>
                {{-- BARRA DE BUSQUEDA --}}
            </div>
            <div
                class="flex flex-col items-stretch justify-end w-full space-y-2 shrink-0 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
                <a href="{{ route('products.create') }}"
                    class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg bg-principal bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-hidden dark:focus:ring-primary-800">
                    <svg class="h-3.5 w-3.5 mr-2" fill="currentColor" viewbox="0 0 20 20"
                        xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                        <path clip-rule="evenodd" fill-rule="evenodd"
                            d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" />
                    </svg>
                    Crear nuevo
                </a>
            </div>
        </div>
    </div>
    {{-- BARRA DE BUSQUEDA --}}
    <div class="grid grid-cols-1 gap-5 mt-5 md:grid-cols-2 xl:grid-cols-3">
        @foreach ($products as $row)
            <div
                class="flex flex-col items-center w-full h-full mt-2 overflow-hidden bg-white border-2 border-gray-100 rounded-lg shadow-xl md:p-0">
                <div class="h-64 overflow-hidden lg:h-60">
                    @if (!is_null($row->image()))
                        <img class="h-full lg:object-contain lg:object-center"
                            src="{{ asset('storage/images/gallery/' . $row->image()) }}" alt="product image">
                    @else
                        <img class="object-contain object-top w-full h-full lg:object-contain lg:object-center "
                            src="{{ asset('storage/muestra/insertarimg.jpeg') }}" alt="product image">
                    @endif
                </div>
                <div class="flex flex-col items-center justify-center w-full py-5 lg:p-5">
                    <h4 class="text-2xl font-semibold text-center uppercase">
                        {{ is_null($row->name) ? '' : $row->name . ' - ' }}
                        {{ $row->category->name }}
                        ({{ $row->contents }}
                        {{ $row->measurement_unit->code }})
                    </h4>

                    {{-- <span class="text-gray-500">{{ $row->code }}</span> --}}
                    <span class="text-xl text-gray-500">
                        <strong>Precio:</strong> ${{ number_format($row->price->price, 2) }}
                    </span>
                    <span class="text-xl text-gray-500"><strong>Inventarío:</strong> {{ $row->quantity() }}</span>
                    <span class="text-xl text-gray-500"><strong>Estado:</strong> {{ $row->status->name }}</span>
                    {{-- <div class="flex gap-3 ">
                            <!-- TALLAS Y EXISTENCIAS -->
                            <label class="text-center">
                                <div class="flex items-center justify-center w-8 h-8 bg-gray-100 rounded-lg text-bold">
                                    Existencia </div>
                                <span class="font-bold ">Tallas</span>
                            </label>
                            @foreach ($row->clothingSizesProducts->where('status_id', '=', 8) as $item)
                                <label class="text-center">
                                    <div class="flex items-center justify-center w-8 h-8 bg-gray-100 rounded-lg ">
                                        {{ $row->quantity($row->id, $item->id) }} </div>
                                    <span class="font-bold uppercase">{{ $item->clothingSize->name }}</span>
                                </label>
                            @endforeach

                            <!-- TALLAS Y EXISTENCIAS -->
                            <div>
                            </div>
                        </div> --}}
                    <div class="flex flex-col items-center justify-center w-full gap-3 mt-3">
                        <a href="{{ route('inventories.edit', $row) }}"
                            class="flex gap-3 px-4 py-2 text-white transition-all duration-300 rounded-lg bg-amber-600 w-fit hover:bg-amber-700">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="w-6 h-6">
                                <path
                                    d="M21.731 2.269a2.625 2.625 0 0 0-3.712 0l-1.157 1.157 3.712 3.712 1.157-1.157a2.625 2.625 0 0 0 0-3.712ZM19.513 8.199l-3.712-3.712-8.4 8.4a5.25 5.25 0 0 0-1.32 2.214l-.8 2.685a.75.75 0 0 0 .933.933l2.685-.8a5.25 5.25 0 0 0 2.214-1.32l8.4-8.4Z" />
                                <path
                                    d="M5.25 5.25a3 3 0 0 0-3 3v10.5a3 3 0 0 0 3 3h10.5a3 3 0 0 0 3-3V13.5a.75.75 0 0 0-1.5 0v5.25a1.5 1.5 0 0 1-1.5 1.5H5.25a1.5 1.5 0 0 1-1.5-1.5V8.25a1.5 1.5 0 0 1 1.5-1.5h5.25a.75.75 0 0 0 0-1.5H5.25Z" />
                            </svg>
                            Editar inventario
                        </a>
                        <a href="{{ route('products.edit', $row) }}"
                            class="flex gap-3 px-4 py-2 text-white transition-all duration-300 rounded-lg bg-amber-600 w-fit hover:bg-amber-700">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993 1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007ZM8.625 10.5a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm7.5 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                            </svg>
                            Editar producto
                        </a>
                        {{-- <a href="{{ route('image-gallery.edit', $row) }}" class="inline-flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M6.827 6.175A2.31 2.31 0 0 1 5.186 7.23c-.38.054-.757.112-1.134.175C2.999 7.58 2.25 8.507 2.25 9.574V18a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 18V9.574c0-1.067-.75-1.994-1.802-2.169a47.865 47.865 0 0 0-1.134-.175 2.31 2.31 0 0 1-1.64-1.055l-.822-1.316a2.192 2.192 0 0 0-1.736-1.039 48.774 48.774 0 0 0-5.232 0 2.192 2.192 0 0 0-1.736 1.039l-.821 1.316Z" />
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M16.5 12.75a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM18.75 10.5h.008v.008h-.008V10.5Z" />
                                </svg>
                                Editar galería
                            </a> --}}
                        {{-- <a href="{{ route('comments.index', $row) }}" class="inline-flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1" stroke="currentColor" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M2.678 11.894a1 1 0 0 1 .287.801 11 11 0 0 1-.398 2c1.395-.323 2.247-.697 2.634-.893a1 1 0 0 1 .71-.074A8 8 0 0 0 8 14c3.996 0 7-2.807 7-6s-3.004-6-7-6-7 2.808-7 6c0 1.468.617 2.83 1.678 3.894m-.493 3.905a22 22 0 0 1-.713.129c-.2.032-.352-.176-.273-.362a10 10 0 0 0 .244-.637l.003-.01c.248-.72.45-1.548.524-2.319C.743 11.37 0 9.76 0 8c0-3.866 3.582-7 8-7s8 3.134 8 7-3.582 7-8 7a9 9 0 0 1-2.347-.306c-.52.263-1.639.742-3.468 1.105" />
                                </svg>
                                Comentarios
                            </a> --}}
                        {{-- <a href="{{ route('suggestions.index', $row) }}" class="inline-flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1" stroke="currentColor" class="size-6">
                                    <path
                                        d="M6 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m-1 0a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0" />
                                    <path
                                        d="M2 1h4.586a1 1 0 0 1 .707.293l7 7a1 1 0 0 1 0 1.414l-4.586 4.586a1 1 0 0 1-1.414 0l-7-7A1 1 0 0 1 1 6.586V2a1 1 0 0 1 1-1m0 5.586 7 7L13.586 9l-7-7H2z" />
                                </svg>
                                Sugerencias
                            </a> --}}
                    </div>
                </div>
            </div>
        @endforeach
        {{--
            <div class="pb-5">{{ $products->links() }} --}}
    </div>
    <div class="py-5">{{ $products->links('vendor.livewire.tailwind') }}</div>
</section>
