<div>
    <a href="{{ route('purchases.index', ['url' => route('purchases.index')]) }}">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-principal rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Regresar</p>
        </button>
    </a>
    <div class="container min-h-screen px-4 py-8 mx-auto max-w-7xl">
        <div class="mx-auto bg-white">
            <div class="px-8 py-6">
                <h2 class="mb-4 text-2xl font-bold text-gray-800 dark:text-white">Estado del Pedido</h2>
                <form wire:submit.prevent="save" class="flex gap-8 lg:gap-12">
                    <div class="flex flex-col w-full gap-4 lg:w-[40%] shadow-xl rounded-xl p-5 h-fit">
                        @foreach ($products as $item)
                            <div
                                class="flex flex-col w-full border-2 border-gray-200 rounded-lg shadow-md lg:flex-row md:p-4">
                                <img class="object-contain object-top h-40"
                                    src="{{ asset('storage/images/gallery/' . $item->product_price->product->image()) }}"
                                    alt="{{ $item->product_price->product->image() }}">
                                <div class="flex flex-col justify-center w-full gap-2 p-3">
                                    <h4 class="text-sm font-semibold md:text-lg text-start lg:text-2xl">
                                        {{ $item->product_price->product->name }}</h4>
                                    <h4 class="text-sm font-bold font-roboto md:text-lg text-start lg:text-xl ">
                                        ${{ number_format($item->product_price->price, 2) }}</h4>
                                    <div class="flex items-center text-xs md:text-lg">
                                        {{-- <button type="button"
                                            class="inline-flex items-center justify-center w-6 h-6 p-1 text-sm font-medium text-gray-900 bg-white border border-gray-300 rounded-full focus:outline-hidden hover:bg-gray-100 focus:ring-4 focus:ring-gray-200 "
                                            wire:click="editInventory({{ $item->id }}, 'minus')"><svg
                                                class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 18 2">
                                                <path stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" stroke-width="2" d="M1 1h16" />
                                            </svg></button> --}}
                                        <p class="font-roboto">{{ $item->quantity }} unidad(es)</p>
                                        {{-- <button type="button"
                                            class="inline-flex items-center justify-center w-6 h-6 p-1 text-sm font-medium text-gray-500 bg-white border border-gray-300 rounded-full ms-3 focus:outline-hidden hover:bg-gray-100 focus:ring-4 focus:ring-gray-200 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:bg-gray-700 dark:hover:border-gray-600 dark:focus:ring-gray-700"
                                            wire:click="editInventory({{ $item->id }}, 'plus')"><svg class="w-3 h-3"
                                                aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                                                viewBox="0 0 18 18">
                                                <path stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" stroke-width="2" d="M9 1v16M1 9h16" />
                                            </svg></button> --}}
                                    </div>
                                    {{-- <button type="button" class="text-red-500"
                                    wire:click="editInventory({{ $item->id }}, 'delete')">Eliminar</button>
                                @include('partials.input-error', ['input' => 'product-' . $item->id]) --}}
                                    {{-- {{ $item->id }} --}}
                                </div>
                            </div>
                        @endforeach
                        @if ($purchase->invoice == 1)
                            <div name class="flex flex-col gap-1 p-4">
                                <h3
                                    class="text-2xl text-[#1d5394] font-semibold leading-none tracking-tight whitespace-nowrap mb-4">
                                    Datos de facturación</h3>
                                <span
                                    class="inline-flex items-center text-principalhover text-sm font-medium leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70"
                                    for="name">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-2">
                                        <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                    Nombre
                                </span>
                                {{ $purchase->data_invoice->full_name }}
                                <span
                                    class="inline-flex items-center text-principalhover text-sm font-medium leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70"
                                    for="name">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.07 1.916l-7.5 4.615a2.25 2.25 0 0 1-2.36 0L3.32 8.91a2.25 2.25 0 0 1-1.07-1.916V6.75" />
                                    </svg>
                                    Correo
                                </span>
                                {{ $purchase->data_invoice->email }}
                                <span
                                    class="inline-flex items-center text-principalhover text-sm font-medium leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70"
                                    for="name">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                        <path
                                            d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.6 17.6 0 0 0 4.168 6.608 17.6 17.6 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.68.68 0 0 0-.58-.122l-2.19.547a1.75 1.75 0 0 1-1.657-.459L5.482 8.062a1.75 1.75 0 0 1-.46-1.657l.548-2.19a.68.68 0 0 0-.122-.58zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.68.68 0 0 0 .178.643l2.457 2.457a.68.68 0 0 0 .644.178l2.189-.547a1.75 1.75 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.6 18.6 0 0 1-7.01-4.42 18.6 18.6 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877z" />
                                    </svg>
                                    Teléfono
                                </span>
                                {{ $purchase->data_invoice->phone }}
                                <span
                                    class="inline-flex items-center text-principalhover text-sm font-medium leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70"
                                    for="name">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M10.125 2.25h-4.5c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125v-9M10.125 2.25h.375a9 9 0 0 1 9 9v.375M10.125 2.25A3.375 3.375 0 0 1 13.5 5.625v1.5c0 .621.504 1.125 1.125 1.125h1.5a3.375 3.375 0 0 1 3.375 3.375M9 15l2.25 2.25L15 12" />
                                    </svg>
                                    RFC
                                </span>
                                {{ $purchase->data_invoice->rfc }}
                                <span
                                    class="inline-flex items-center text-principalhover text-sm font-medium leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70"
                                    for="name">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M8.25 6.75h12M8.25 12h12m-12 5.25h12M3.75 6.75h.007v.008H3.75V6.75Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0ZM3.75 12h.007v.008H3.75V12Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm-.375 5.25h.007v.008H3.75v-.008Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                                    </svg>
                                    CFDI
                                </span>
                                {{ $purchase->data_invoice->CFDICatalog->key }} -
                                {{ $purchase->data_invoice->CFDICatalog->description }}
                            </div>
                        @endif
                    </div>
                    <div class="flex flex-col w-full lg:w-[60%] shadow-xl rounded-xl p-5">
                        <div class="p-3 my-4 font-semibold bg-blue-200 rounded-lg">
                            <label class="block mb-2 text-3xl font-semibold text-gray-700 dark:text-white"
                                for="status_id">Dirección</label>
                            <label class="block mb-2 text-gray-700 dark:text-white">Calle y número:
                                {{ $purchase->address_purchase->address->main_street }}</label>
                            <label class="block mb-2 text-gray-700 dark:text-white">Ciudad:
                                {{ $purchase->address_purchase->address->between_streets }}</label>
                            <label class="block mb-2 text-gray-700 dark:text-white">Código Postal:
                                {{ $purchase->address_purchase->address->zip_code }}</label>
                            <label class="block mb-2 text-gray-700 dark:text-white">Referencías del domicilio:
                                {{ $purchase->address_purchase->address->reference }}</label>
                            <label class="block mb-2 text-gray-700 dark:text-white">Colonia:
                                {{ $purchase->address_purchase->address->neighborhood }}</label>
                        </div>

                        <div class="mb-4">
                            <label for="guide_one"
                                class="block mb-2 font-bold text-gray-700 dark:text-white">Guía</label>
                            <input type="text" id="guide_one" name="guide_one" wire:model="guide_one" max="35"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'guide_one'])
                        </div>
                        {{-- <div class="mb-4">
                        <label for="guide_two" class="block mb-2 font-bold text-gray-700 dark:text-white">Guía 2</label>
                        <input type="text" id="guide_two" name="guide_two" wire:model="guide_two" max="35"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                        @include('partials.input-error', ['input' => 'guide_two'])
                    </div> --}}
                        <div class="mb-4">
                            <label for="shipping"
                                class="block mb-2 font-bold text-gray-700 dark:text-white">Envio</label>
                            <input type="number" id="shipping" name="shipping" wire:model="shipping"
                                wire:change="listProducts()"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'shipping'])
                        </div>
                        <div class="mb-4">
                            <label for="payment_date" class="block mb-2 font-bold text-gray-700 dark:text-white">Fecha
                                Maxima
                                de Pago</label>
                            <input type="date" wire:model="payment_date"
                                min="{{ \Carbon\Carbon::today()->format('Y-m-d') }}">
                            @include('partials.input-error', ['input' => 'payment_date'])
                        </div>

                        <div class="flex flex-col p-3 bg-green-200 rounded-lg">
                            <div class="">
                                <label class="block mb-2 font-semibold text-gray-700 dark:text-white">Subtotal
                                    ${{ number_format($clothes, 2) }}</label>
                            </div>
                            <div class="">
                                <label class="block mb-2 font-semibold text-gray-700 dark:text-white">Envío
                                    ${{ number_format($shipping, 2) }}</label>
                            </div>
                            <div class="">
                                <label class="block mb-2 text-lg font-bold text-gray-700 dark:text-white">Total
                                    ${{ number_format($total, 2) }}</label>
                            </div>
                        </div>
                        <div class="mb-4">
                            <label class="block mb-2 font-bold text-gray-700 dark:text-white"
                                for="status_id">Estado</label>
                            <div class="relative">
                                <select wire:model.lazy="status_id"
                                    class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                    id="status_id">
                                    @foreach ($status as $row)
                                        <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                                <div
                                    class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M5 6l5 5 5-5z" />
                                    </svg>
                                </div>
                            </div>
                            @include('partials.input-error', ['input' => 'status_id'])
                        </div>
                        <div class="flex items-center justify-between">
                            <button type="submit"
                                class="px-4 py-2 font-bold text-white transition-all duration-200 rounded-sm bg-principal hover:bg-principalhover">
                                Guardar
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
