<div>
    <a href="{{ route('suggestions.index', $product) }}">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-orange-400 rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Regresar</p>
        </button>
    </a>
    <div class="min-h-screen mb-4 rounded-lg shadow-xl dark:-gray-600">

        <!-- Start block -->
        <section class="p-3 antialiased bg-gray-50 dark:bg-gray-900 sm:p-5">
            <div class="mx-auto ">
                <!-- Start coding here -->
                <div class="relative overflow-hidden bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
                    <button wire:click="openModal"
                        class="block my-3 ml-3 text-white bg-orange-400 hover:bg-orange-500  focus:ring-4 focus:outline-hidden focus:ring-orange-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-orange-600 dark:hover:bg-orange-700 dark:focus:ring-orange-800"
                        type="button">
                        Agregar productos a la lista
                    </button>
                    <div class="overflow-x-auto ">
                        <form wire:submit.prevent="save">
                            <div class="flex flex-col lg:flex-row">
                                {{-- <div class="p-3 lg:w-2/5 ">
                                    <div class="mb-4">
                                        <label for="educational_levels_school_id"
                                            class="block mb-2 text-sm font-medium text-gray-900 dark:text-slate-800">Escuela</label>
                                        <select id="educational_levels_school_id"
                                            wire:model="educational_levels_school_id"
                                            class="bg-gray-50 border border-gray-300 dark:border dark:border-white text-gray-900 text-sm rounded-lg focus:ring-orange-500 focus:border-orange-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-slate-800 dark:focus:ring-orange-500 dark:focus:border-orange-500">
                                            @foreach ($educational_levels_schools as $row)
                                                <option value="{{ $row->id }}">{{ $row->school->name }} -
                                                    {{ $row->educationalLevel->name }}</option>
                                            @endforeach
                                        </select>
                                        @include('partials.input-error', [
                                            'input' => 'educational_levels_school_id',
                                        ])
                                    </div>
                                    <div class="flex flex-col mb-4">
                                        <label for="educational_levels_school_id"
                                            class="block mb-2 text-sm font-medium text-gray-900 dark:text-slate-800">Grados</label>
                                        @foreach ($data as $row)
                                            <label class="text-slate-800" for="grade{{ $row->id }}">
                                                <input type="checkbox" wire:model="grades" value="{{ $row->id }}"
                                                    id="grade{{ $row->id }}"> {{ $row->name }}° año
                                            </label>
                                        @endforeach
                                        @include('partials.input-error', ['input' => 'grades'])
                                    </div>

                                    <div class="mb-4">
                                        <label for="name"
                                            class="block mb-2 font-semibold text-gray-700 dark:text-slate-800">Titulo de
                                            la Lista</label>
                                        <input type="text" id="name" name="name" wire:model="name"
                                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-orange-500 focus:border-orange-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-slate-800 dark:focus:ring-orange-500 dark:focus:border-orange-500">
                                        @include('partials.input-error', ['input' => 'name'])
                                    </div>
                                    <div class="mb-4">
                                        <label for="name"
                                            class="block mb-2 font-semibold text-gray-700 dark:text-slate-800">Ciclo
                                            Escolar</label>
                                        <input type="text" id="school_cycle" name="school_cycle"
                                            wire:model="school_cycle"
                                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-orange-500 focus:border-orange-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-slate-800 dark:focus:ring-orange-500 dark:focus:border-orange-500">
                                        @include('partials.input-error', ['input' => 'school_cycle'])
                                    </div>
                                </div> --}}
                                @include('partials.input-error', ['input' => 'list'])
                                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400 rounded-xl">
                                    <thead
                                        class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                                        <tr>
                                            <th scope="col" class="px-4 py-4">Nombre</th>
                                            <th scope="col" class="px-4 py-3">Cantidad</th>
                                            <th scope="col" class="px-2 py-2">
                                                <span class="sr-only">Actions</span>
                                                <span class="">Acciones</span>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($list as $index => $row)
                                            <tr class="border-b dark:border-gray-700">
                                                <th scope="row"
                                                    class="w-full px-4 py-3 overflow-hidden font-medium text-gray-900 dark:text-slate-800">
                                                    {{ $row['name'] }}</th>
                                                <td class="w-1/12 px-4 py-3 truncate">
                                                    {{ $product->image() }}
                                                    {{-- {{ $pro }} --}}
                                                    {{-- @if (count($product->images)>0)
                                                        <img src="{{ asset('storage/images/gallery/' . $product->path) }}" alt="">
                                                    @endif --}}
                                                    {{-- <input type="number"
                                                        wire:model.lazy="list.{{ $index }}.quantity"
                                                        min="0" max="100" required
                                                        wire:change="updateQuantity({{ $index }}, $event.target.value)"
                                                        class="w-bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-orange-500 focus:border-orange-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-slate-800 dark:focus:ring-orange-500 dark:focus:border-orange-500"> --}}
                                                </td>
                                                <td>
                                                    <div class="flex flex-col items-start w-1/12 gap-2">
                                                        <button type="button" class="inline-flex items-center"
                                                            wire:click="deselectProduct({{ $row['id'] }})">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="w-6 h-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
                                                            </svg>
                                                            Quitar
                                                        </button>
                                                        <!-- Estilos con Tailwind CSS -->
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <hr>
                            <div class="flex gap-6 pl-5 ">
                                {{-- <a href="{{ route('school-list.index') }}"
                                class="focus:outline-hidden text-slate-800 bg-white mt-5 border border-orange-400 hover:bg-gray-200  focus:ring-4 focus:ring-orange-300 font-medium rounded-lg text-sm px-5 py-2.5 me-2 mb-2 dark:bg-orange-600">
                                Regresar
                            </a> --}}
                                <button
                                    class="focus:outline-hidden text-white bg-orange-400 mt-5 hover:bg-orange-500  focus:ring-4 focus:ring-orange-300 font-medium rounded-lg text-sm px-5 py-2.5 me-2 mb-2 dark:bg-orange-600 "
                                    type="submit">Guardar</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>



    @if ($isOpen)
        <div class="fixed inset-0 z-50 flex items-center justify-center px-10 overflow-auto bg-black bg-opacity-50 ">
            <div
                class="relative w-full p-8 overflow-auto bg-white rounded-lg shadow-lg max-h-[30rem] dark:bg-gray-800/90">
                <button wire:click="closeModal"
                    class="absolute top-0 right-0 flex items-center justify-center w-10 h-10 mx-auto mt-4 mr-4 text-4xl text-center text-red-500 rounded-xl hover:text-gray-700">
                    &times;
                </button>
                <div
                    class="flex flex-col items-center justify-between p-4 space-y-3 md:flex-row md:space-y-0 md:space-x-4">
                    <div class="w-full md:w-1/2">
                        {{-- BARRA DE BUSQUEDA --}}
                        <div class="flex items-center">
                            <label for="simple-search" class="sr-only">Búsqueda</label>
                            <div class="relative w-full lg:w-2/3">
                                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                    <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400"
                                        fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd"
                                            d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <input type="text" id="simple-search" wire:keydown="searchElement()"
                                    wire:model="search"
                                    class="block w-full p-2 pl-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-slate-800 dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="Búsqueda" required="">
                            </div>
                        </div>
                        {{-- BARRA DE BUSQUEDA --}}
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <h4 class="text-2xl font-bold text-slate-800">Lista de productos</h4>
                    <table class="w-full px-3 mt-4 text-sm text-left text-gray-500 dark:text-gray-400">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr>
                                <th scope="col" class="px-4 py-4">Nombre</th>
                                <th scope="col" class="px-4 py-3">Descripción</th>
                                <th scope="col" class="px-2 py-2">
                                    <span class="sr-only">Actions</span>
                                    <span class="">Acciones</span>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($products as $row)
                                <tr class="border-b dark:border-gray-700">
                                    <th scope="row"
                                        class="ñ px-4 py-3 overflow-hidden font-medium text-gray-900 dark:text-slate-800">
                                        {{ $row->name }}</th>
                                    <td class="px-4 py-3 tru w-ncate ">{{ $row->description }}</td>
                                    <td>
                                        <div class="flex flex-col items-start gap-2 px-3">
                                            <button class="inline-flex items-center"
                                                wire:click="selectProduct({{ $row->id }})">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    class="w-6 h-6">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="M12 4.5v15m7.5-7.5h-15" />
                                                </svg>
                                                Agregar
                                            </button>
                                            <!-- Estilos con Tailwind CSS -->
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="flex justify-end">
                    <button wire:click="closeModal"
                        class="px-4 py-2 mt-10 mr-2 font-bold text-white bg-red-600 rounded-sm hover:bg-red-700">Cerrar</button>
                    {{-- <button class="px-4 py-2 font-bold bg-orange-500 rounded-sm text-slate-800 hover:bg-orange-700">Save changes</button> --}}
                </div>
            </div>
        </div>
    @endif
    {{--    MODAL --}}

</div>
