<div class="flex items-center justify-center h-screen bg-center bg-cover"
    style="background-image: url('{{ asset('storage/auth-images/fondo_granos.jpg') }}');">
    <a href="/login" class="absolute z-20 top-5 left-5">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-principal rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Regresar</p>
        </button>
    </a>
    <div
        class="max-w-md max-h-full p-8 mx-auto my-auto bg-white rounded-lg shadow-lg dark:bg-gray-900 bg-opacity-30 dark:bg-opacity-90">
        {{-- @include('partials.error-alert') --}}
        <div class="max-w-md px-8 py-6 bg-white rounded-lg dark:bg-gray-900">
            <div class="flex justify-center mb-4">
                <img class="h-12 xl:h-16" src="{{ asset('storage/logos/favicon-310x310.png') }}"
                    alt="logo finca monte verde">
            </div>
            <h1 class="mb-4 text-2xl font-bold text-center dark:text-gray-200">Recuperar Contraseña</h1>
            @include('partials.required-fields')
            <form wire:submit.prevent="store">
                <div class="mb-4">
                    <label for="email" class="text-lg font-medium text-gray-700 dark:text-gray-400">Correo:
                        @include('partials.required')</label>
                    <input wire:model="email" type="text" id="email"
                        class="w-full px-4 py-3 mt-3 rounded-lg dark:text-gray-400 dark:bg-gray-800" name="email"
                        placeholder="Ingrese su correo">
                    @include('partials.message', ['input' => 'email'])
                </div>

                <button type="submit"
                    class="flex justify-center w-full px-4 py-2 text-sm font-medium text-white bg-blue-600 border border-transparent rounded-md shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Recuperar Contraseña
                </button>
            </form>
        </div>
    </div>
</div>
