<div class="flex items-center justify-center bg-gray-100 py-10">
    <div class="w-full max-w-2xl bg-white shadow-xl overflow-hidden">
        <a href="/direcciones">
            <button type="button"
                class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
                <div
                    class="bg-principal rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                    <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                        <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                        <path fill="#ffff"
                            d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                        </path>
                    </svg>
                </div>
                <p class="translate-x-2">Regresar</p>
            </button>
        </a>
        <div class="bg-principal px-6 py-4 rounded-t-2xl mt-4">
            <h2 class="text-2xl font-bold text-white">Editar Dirección</h2>
        </div>
        <div class="p-6">
            <form wire:submit="save" class="space-y-5">
                <div>
                    <label for="main_street" class="block mb-2 text-sm font-semibold text-gray-700 dark:text-gray-200">
                        Calle y número
                    </label>
                    <input type="text" id="main_street" name="main_street" wire:model="main_street"
                        class="w-full px-4 py-2 text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-principal focus:border-transparent transition">
                    @include('partials.input-error', ['input' => 'main_street'])
                </div>
                <div>
                    <label for="between_streets"
                        class="block mb-2 text-sm font-semibold text-gray-700 dark:text-gray-200">
                        Ciudad
                    </label>
                    <input type="text" id="between_streets" name="between_streets" wire:model="between_streets"
                        class="w-full px-4 py-2 text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-principal focus:border-transparent transition">
                    @include('partials.input-error', ['input' => 'between_streets'])
                </div>
                <div>
                    <label for="zip_code" class="block mb-2 text-sm font-semibold text-gray-700 dark:text-gray-200">
                        Código Postal
                    </label>
                    <input type="text" id="zip_code" name="zip_code" wire:model="zip_code"
                        class="w-full px-4 py-2 text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-principal focus:border-transparent transition">
                    @include('partials.input-error', ['input' => 'zip_code'])
                </div>
                <div>
                    <label for="reference" class="block mb-2 text-sm font-semibold text-gray-700 dark:text-gray-200">
                        Referencias del domicilio
                    </label>
                    <textarea id="reference" name="reference" wire:model="reference" rows="3"
                        class="w-full px-4 py-2 text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-principal focus:border-transparent transition"></textarea>
                    @include('partials.input-error', ['input' => 'reference'])
                </div>
                <div>
                    <label for="neighborhood" class="block mb-2 text-sm font-semibold text-gray-700 dark:text-gray-200">
                        Colonia
                    </label>
                    <input type="text" id="neighborhood" name="neighborhood" wire:model="neighborhood"
                        class="w-full px-4 py-2 text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-principal focus:border-transparent transition">
                    @include('partials.input-error', ['input' => 'neighborhood'])
                </div>
                <div class="flex justify-end">
                    <button type="submit"
                        class="px-6 py-2 font-semibold text-white bg-principal rounded-lg shadow-md hover:bg-principalhover focus:outline-none focus:ring-2 focus:ring-principal transition">
                        Guardar Dirección
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
